/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.common.IConfigurableTool;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class UpdateConfigurableToolPacket
extends CustomPacket {
    private final InteractionHand hand;
    private final ItemStack itemStack;

    public UpdateConfigurableToolPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(InteractionHand.class);
        this.itemStack = buffer.readItem();
    }

    public UpdateConfigurableToolPacket(InteractionHand hand, ItemStack itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeItem(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ItemStack oldItemStack = player.getItemInHand(this.hand);
        if (!(oldItemStack.getItem() instanceof IConfigurableTool)) {
            this.abort((Player)player, "update", "tried change unsupported item type.");
            return;
        }
        if (!oldItemStack.getItem().equals(this.itemStack.getItem())) {
            this.abort((Player)player, "update", "tried change item type.");
            return;
        }
        ItemStack newItemStack = oldItemStack.copy();
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_OPTIONS.get());
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
        player.setItemInHand(this.hand, newItemStack);
    }

    private <T> void copyTo(ItemStack fromItemStack, ItemStack toItemStack, IDataComponentType<T> key) {
        T value = ComponentAPI.get(fromItemStack, key);
        ComponentAPI.set(toItemStack, key, value);
    }

    private void abort(Player player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, player.getScoreboardName(), reason, player.getItemInHand(this.hand), this.itemStack);
    }
}

