/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.core.blockentity.SkinningTableBlockEntity;
import moe.plushie.armourers_workshop.core.crafting.recipe.SkinningRecipes;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class SkinningTableMenu
extends AbstractBlockEntityMenu<SkinningTableBlockEntity> {
    private final Container inventory;

    public SkinningTableMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.inventory = ((SkinningTableBlockEntity)this.blockEntity).getContainer();
        this.addPlayerSlots((Container)playerInventory, 8, 94);
        this.addInputSlot(this.inventory, 1, 37, 22);
        this.addInputSlot(this.inventory, 2, 37, 58);
        this.addOutputSlot(this.inventory, 0, 119, 40);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        return this.quickMoveStack(player, index, this.slots.size() - 1);
    }

    protected void addInputSlot(Container inventory, int slot, int x, int y) {
        this.addSlot(new Slot(inventory, slot, x, y){

            public void setChanged() {
                super.setChanged();
                SkinningTableMenu.this.onCraftSlotChanges();
            }
        });
    }

    protected void addOutputSlot(final Container inventory, int slot, int x, int y) {
        this.addSlot(new Slot(inventory, slot, x, y){

            public boolean mayPlace(ItemStack itemStack) {
                return false;
            }

            public void set(ItemStack itemStack) {
                if (itemStack.isEmpty()) {
                    SkinningRecipes.onCraft(inventory, ((SkinningTableBlockEntity)SkinningTableMenu.this.blockEntity).options());
                    super.set(itemStack);
                    SkinningTableMenu.this.onCraftSlotChanges();
                }
            }
        });
    }

    public void onCraftSlotChanges() {
        this.inventory.setItem(0, SkinningRecipes.getRecipeOutput(this.inventory, ((SkinningTableBlockEntity)this.blockEntity).options()));
    }
}

