/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SkinSlot
extends Slot {
    protected final Collection<SkinSlotType> slotTypes;
    private ArrayList<Pair<ResourceLocation, ResourceLocation>> backgroundPairs;

    public SkinSlot(Container inventory, int index, int x, int y, SkinSlotType ... slotTypes) {
        super(inventory, index, x, y);
        this.slotTypes = Collections.newList(slotTypes);
    }

    public boolean mayPlace(ItemStack itemStack) {
        if (!this.slotTypes.isEmpty() && !this.slotTypes.contains((Object)SkinSlotType.byItem(itemStack))) {
            return false;
        }
        return this.container.canPlaceItem(this.index, itemStack);
    }

    public Collection<SkinSlotType> slotTypes() {
        return this.slotTypes;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        int size;
        if (this.backgroundPairs == null) {
            this.backgroundPairs = new ArrayList();
            for (SkinSlotType slotType : this.slotTypes) {
                this.backgroundPairs.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)slotType.icon().toLocation()));
            }
        }
        if ((size = this.backgroundPairs.size()) > 0) {
            return this.backgroundPairs.get((int)(System.currentTimeMillis() / 1000L % (long)size));
        }
        return null;
    }
}

