/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import java.util.function.BooleanSupplier;
import moe.plushie.armourers_workshop.compatibility.core.AbstractContainerMenuImpl;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerMenu
extends AbstractContainerMenuImpl {
    public AbstractContainerMenu(@Nullable MenuType<?> containerType, int containerId) {
        super(containerType, containerId);
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public ItemStack quickMoveStack(Player player, int index, int slotSize) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = slot.getItem();
        if (index >= 36) {
            if (!this.moveItemStackTo(itemStack, 0, 9, false) && !this.moveItemStackTo(itemStack, 9, 36, false)) {
                return ItemStack.EMPTY;
            }
            slot.set(ItemStack.EMPTY);
            return itemStack.copy();
        }
        if (!this.moveItemStackTo(itemStack, 36, slotSize, false)) {
            return ItemStack.EMPTY;
        }
        slot.setChanged();
        return ItemStack.EMPTY;
    }

    protected void addPlayerSlots(Container inventory, int slotsX, int slotsY) {
        this.addPlayerSlots(inventory, slotsX, slotsY, Slot::new);
    }

    protected void addPlayerSlots(Container inventory, int slotsX, int slotsY, ISlotBuilder builder) {
        for (int col = 0; col < 9; ++col) {
            this.addSlot(builder.create(inventory, col, slotsX + col * 18, slotsY + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(builder.create(inventory, col + row * 9 + 9, slotsX + col * 18, slotsY + row * 18));
            }
        }
    }

    protected ISlotBuilder visibleSlotBuilder(final BooleanSupplier supplier) {
        return (inv, slot, x, y) -> new Slot(this, inv, slot, x, y){

            public boolean isActive() {
                return supplier.getAsBoolean();
            }
        };
    }

    public static interface ISlotBuilder {
        public Slot create(Container var1, int var2, int var3, int var4);
    }
}

