/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.api.core.math.IVector2f;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenVector2f
implements IVector2f {
    public static final int BYTES = 12;
    public static OpenVector2f ZERO = new OpenVector2f();
    public float x;
    public float y;

    public OpenVector2f() {
    }

    public OpenVector2f(IVector2f value) {
        this(value.x(), value.y());
    }

    public OpenVector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public OpenVector2f(double x, double y) {
        this((float)x, (float)y);
    }

    public static OpenVector2f of(long value) {
        float p1 = Float.intBitsToFloat((int)value);
        float p2 = Float.intBitsToFloat((int)(value >> 32));
        return new OpenVector2f(p1, p2);
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    public long asLong() {
        int p1 = Float.floatToRawIntBits(this.x);
        int p2 = Float.floatToRawIntBits(this.y);
        return (long)p2 << 32 | (long)p1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector2f)) {
            return false;
        }
        OpenVector2f that = (OpenVector2f)o;
        return Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return OpenMath.format("(%f %f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

