/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.Stack;
import moe.plushie.armourers_workshop.api.core.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;

public class OpenPoseStack
implements IPoseStack {
    protected Pose entry = new Pose();
    protected Stack<Pose> stack;

    public OpenPoseStack() {
    }

    public OpenPoseStack(IPoseStack poseStack) {
        this.entry.set(poseStack.last());
    }

    @Override
    public void pushPose() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(this.entry);
        this.entry = new Pose(this.entry);
    }

    @Override
    public void popPose() {
        if (this.stack == null || this.stack.isEmpty()) {
            return;
        }
        this.entry = this.stack.pop();
    }

    @Override
    public void setIdentity() {
        this.entry.pose.setIdentity();
        this.entry.normal.setIdentity();
        this.entry.properties = 0;
    }

    @Override
    public void translate(float x, float y, float z) {
        this.entry.pose.multiply(OpenMatrix4f.createTranslateMatrix(x, y, z));
    }

    @Override
    public void scale(float x, float y, float z) {
        this.entry.pose.scale(x, y, z);
        if (Math.abs(x) == Math.abs(y) && Math.abs(y) == Math.abs(z)) {
            if (x < 0.0f || y < 0.0f || z < 0.0f) {
                this.entry.normal.scale(Math.signum(x), Math.signum(y), Math.signum(z));
            }
        } else {
            this.entry.normal.scale(1.0f / x, 1.0f / y, 1.0f / z);
            this.entry.properties |= 2;
        }
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        this.entry.pose.rotate(quaternion);
        this.entry.normal.rotate(quaternion);
    }

    @Override
    public void multiply(IMatrix3f matrix) {
        this.entry.normal.multiply(matrix);
    }

    @Override
    public void multiply(IMatrix4f matrix) {
        this.entry.pose.multiply(matrix);
    }

    public OpenPoseStack copy() {
        OpenPoseStack poseStack = new OpenPoseStack();
        poseStack.entry.set(this.entry);
        return poseStack;
    }

    @Override
    public Pose last() {
        return this.entry;
    }

    public static class Pose
    implements IPoseStack.Pose {
        protected final OpenMatrix4f pose;
        protected final OpenMatrix3f normal;
        protected int properties;

        public Pose() {
            this.pose = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
            this.normal = OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        }

        public Pose(OpenMatrix4f pose, OpenMatrix3f normal) {
            this.pose = pose;
            this.normal = normal;
        }

        public Pose(IPoseStack.Pose entry) {
            this.pose = new OpenMatrix4f(entry.pose());
            this.normal = new OpenMatrix3f(entry.normal());
            this.properties = entry.properties();
        }

        @Override
        public void transformPose(float[] values) {
            this.pose.multiply(values);
        }

        @Override
        public void transformNormal(float[] values) {
            this.normal.multiply(values);
            if ((this.properties & 2) != 0) {
                OpenMath.normalize(values);
            }
        }

        @Override
        public void set(IPoseStack.Pose entry) {
            this.pose.set(entry.pose());
            this.normal.set(entry.normal());
            this.properties = entry.properties();
        }

        @Override
        public OpenMatrix4f pose() {
            return this.pose;
        }

        @Override
        public OpenMatrix3f normal() {
            return this.normal;
        }

        public void setProperties(int properties) {
            this.properties = properties;
        }

        @Override
        public int properties() {
            return this.properties;
        }
    }
}

