/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SkinUnlockItem
extends FlavouredItem {
    private final SkinSlotType slotType;

    public SkinUnlockItem(SkinSlotType slotType, Item.Properties properties) {
        super(properties);
        this.slotType = slotType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        SkinType skinType = this.slotType.skinType();
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || skinType == null) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        MutableComponent skinName = TranslateUtils.Name.of(skinType);
        if (wardrobe.getUnlockedSize(this.slotType) >= this.slotType.maxSize()) {
            player.sendSystemMessage((Component)Component.translatable((String)"chat.armourers_workshop.slotUnlockedFailed", (Object[])new Object[]{skinName}));
            return InteractionResultHolder.fail((Object)itemStack);
        }
        int count = wardrobe.getUnlockedSize(this.slotType) + 1;
        wardrobe.setUnlockedSize(this.slotType, count);
        wardrobe.broadcast();
        player.sendSystemMessage((Component)Component.translatable((String)"chat.armourers_workshop.slotUnlocked", (Object[])new Object[]{skinName, Integer.toString(count)}));
        ItemStack resultStack = itemStack.copy();
        resultStack.shrink(1);
        player.setItemInHand(hand, resultStack);
        return InteractionResultHolder.consume((Object)itemStack);
    }
}

