/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MannequinItem
extends FlavouredItem {
    public MannequinItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean isSmall(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.isSmall();
        }
        return false;
    }

    public static float getScale(ItemStack itemStack) {
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag != null) {
            MannequinEntity.EntityData entityData = new MannequinEntity.EntityData(entityTag);
            return entityData.scale();
        }
        return 1.0f;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getHand() != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        Vec3 origin = new Vec3(player.getX(), player.getY(), player.getZ());
        MannequinHitResult rayTraceResult = MannequinHitResult.test(player, origin, context.getClickLocation(), context.getClickedPos());
        ItemStack itemStack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MannequinEntity entity = (MannequinEntity)((IEntityType)ModEntityTypes.MANNEQUIN.get()).create(serverLevel, rayTraceResult.getBlockPos(), itemStack, MobSpawnType.SPAWN_EGG);
            if (entity == null) {
                return InteractionResult.FAIL;
            }
            Vec3 clickedLocation = rayTraceResult.getLocation();
            entity.absMoveTo(clickedLocation.x(), clickedLocation.y(), clickedLocation.z(), 0.0f, 0.0f);
            entity.setYBodyRot(rayTraceResult.rotation());
            serverLevel.addFreshEntity((Entity)entity);
            serverLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)serverLevel.isClientSide());
        }
        return InteractionResult.FAIL;
    }

    public String getDescriptionId(ItemStack itemStack) {
        float scale = MannequinItem.getScale(itemStack);
        if (scale <= 0.5f) {
            return super.getDescriptionId(itemStack) + ".small";
        }
        if (scale >= 2.0f) {
            return super.getDescriptionId(itemStack) + ".big";
        }
        return super.getDescriptionId(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<Component> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.of(itemStack);
        if (descriptor.name() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.user", descriptor.name()));
        }
        if (descriptor.url() != null) {
            tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.url", descriptor.url()));
        }
    }
}

