/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.NonNullItemList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SimpleContainer
implements Container,
IDataSerializable.Mutable {
    private final NonNullItemList items;
    private List<ContainerListener> listeners;

    public SimpleContainer(int size) {
        this.items = new NonNullItemList(size);
    }

    public void addListener(ContainerListener containerListener) {
        if (this.listeners == null) {
            this.listeners = Collections.newList(new ContainerListener[0]);
        }
        this.listeners.add(containerListener);
    }

    public void removeListener(ContainerListener containerListener) {
        if (this.listeners != null) {
            this.listeners.remove(containerListener);
        }
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        this.items.serialize(serializer);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.items.deserialize(serializer);
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack removeItem(int i, int j) {
        ItemStack itemStack = ContainerHelper.removeItem((List)((Object)this.items), (int)i, (int)j);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem((List)((Object)this.items), (int)i);
    }

    public void setItem(int i, ItemStack itemStack) {
        this.items.set(i, itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
        if (this.listeners != null) {
            for (ContainerListener listener : this.listeners) {
                listener.containerChanged((Container)this);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public NonNullItemList getItems() {
        return this.items;
    }
}

