/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MannequinHitResult
extends BlockHitResult {
    private final float scale;
    private final float rotation;

    public MannequinHitResult(BlockPos pos, Vec3 location, float scale, float rotation) {
        super(location, Direction.UP, pos, false);
        this.scale = scale;
        this.rotation = rotation;
    }

    public static MannequinHitResult test(Player player, Vec3 origin, Vec3 target, BlockPos pos) {
        Level level = PropertyProvider.getLevel((Entity)player);
        ItemStack itemStack = player.getMainHandItem();
        float scale = MannequinItem.getScale(itemStack);
        float rotation = (float)OpenMath.getAngleDegrees(origin.x(), origin.z(), target.x(), target.z()) + 90.0f;
        if (MannequinItem.isSmall(itemStack)) {
            scale *= 0.5f;
        }
        BlockState blockState = level.getBlockState(pos);
        if (player.isSecondaryUseActive()) {
            VoxelShape shape = blockState.getShape((BlockGetter)level, pos);
            target = Vec3.upFromBottomCenterOf((Vec3i)pos, (double)shape.max(Direction.Axis.Y));
            VoxelShape collisionShape = blockState.getCollisionShape((BlockGetter)level, pos);
            if (!Block.isFaceFull((VoxelShape)collisionShape, (Direction)Direction.UP)) {
                BlockHitResult collisionBox;
                Vec3 newLocation = Vec3.atBottomCenterOf((Vec3i)pos);
                if (!collisionShape.isEmpty() && (collisionBox = shape.clip(target, newLocation, pos)) != null) {
                    newLocation = collisionBox.getLocation();
                }
                target = newLocation;
            }
            int l = OpenMath.floori((double)(player.getYRot() * 16.0f / 360.0f) + 0.5) % 16;
            rotation = (float)l * 22.5f + 180.0f;
        }
        return new MannequinHitResult(pos, target, scale, rotation);
    }

    public float scale() {
        return this.scale;
    }

    public float rotation() {
        return this.rotation;
    }
}

