/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.data.action.EntityAction;
import moe.plushie.armourers_workshop.core.data.action.EntityActionSet;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.Nullable;

public class EntityAnimationState
extends EntityActionSet {
    private Entity transitingVehicle = null;
    private TransitingMode transitingMode = null;

    @Nullable
    public static EntityAnimationState of(@Nullable Entity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).animationState().orElse(null);
        }
        return null;
    }

    public void startRiding(Entity target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.UP;
    }

    public void stopRiding(Entity target) {
        this.transitingVehicle = target;
        this.transitingMode = TransitingMode.DOWN;
    }

    public void tick(Entity entity) {
        LivingEntity livingEntity;
        this.flags.clear();
        if (entity.isSpectator()) {
            return;
        }
        Entity vehicle = entity.getVehicle();
        if (vehicle == null) {
            vehicle = this.transitingVehicle;
        }
        boolean onGround = entity.onGround() || entity.isNoGravity();
        double dx = entity.getX() - entity.xOld;
        double dy = entity.getY() - entity.yOld;
        double dz = entity.getZ() - entity.zOld;
        boolean isWalk = dx * dx + dz * dz > 2.5E-7;
        boolean isWalkUp = dy > 1.0E-7;
        boolean isWalkDown = dy < -1.0E-7;
        boolean isSprinting = entity.isSprinting();
        boolean isCrouching = entity.isCrouching();
        if (vehicle != null) {
            this.set(EntityAction.RIDING, true);
            this.set(EntityAction.RIDING_WALK, isWalk);
            this.set(EntityAction.RIDING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.RIDING_UP, this.transitingMode == TransitingMode.UP);
            this.set(EntityAction.RIDING_DOWN, this.transitingMode == TransitingMode.DOWN);
            this.set(EntityAction.RIDING_BOAT, this.isBoat(vehicle));
            this.set(EntityAction.RIDING_PIG, this.isPig(vehicle));
            this.set(EntityAction.RIDING_HORSE, this.isHorse(vehicle));
            if (this.transitingMode != null && entity.getPose() != Pose.CROUCHING) {
                this.transitingVehicle = null;
                this.transitingMode = null;
            }
            return;
        }
        if (entity instanceof LivingEntity && this.isFlying(livingEntity = (LivingEntity)entity)) {
            this.set(EntityAction.FLYING, true);
            this.set(EntityAction.FLYING_WALK, isWalk);
            this.set(EntityAction.FLYING_BOOST, isWalk && isSprinting);
            this.set(EntityAction.FLYING_UP, isWalkUp);
            this.set(EntityAction.FLYING_DOWN, isWalkDown);
            this.set(EntityAction.FLYING_FALL, livingEntity.isFallFlying());
            return;
        }
        if (entity.isInWater()) {
            this.set(EntityAction.SWIMMING, true);
            this.set(EntityAction.SWIMMING_WALK, isWalk);
            this.set(EntityAction.SWIMMING_BOOST, entity.isSwimming());
            this.set(EntityAction.SWIMMING_UP, isWalkUp);
            this.set(EntityAction.SWIMMING_DOWN, isWalkDown && !onGround);
            return;
        }
        if (entity.getPose() == Pose.SWIMMING) {
            this.set(EntityAction.CRAWLING, true);
            this.set(EntityAction.CRAWLING_WALK, isWalk);
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).onClimbable()) {
            this.set(EntityAction.CLIMBING, true);
            this.set(EntityAction.CLIMBING_WALK, isWalk);
            this.set(EntityAction.CLIMBING_UP, isWalkUp && !onGround);
            this.set(EntityAction.CLIMBING_DOWN, isWalkDown && !onGround && !isCrouching);
            this.set(EntityAction.CLIMBING_HOLD, isCrouching && !onGround && !isWalkUp);
            return;
        }
        this.set(EntityAction.WALK, isWalk);
        this.set(EntityAction.RUNNING, isSprinting);
        this.set(EntityAction.SNEAK, isCrouching);
        this.set(EntityAction.JUMP, !onGround);
    }

    private boolean isFlying(LivingEntity entity) {
        return WingPartTransform.isFlying(entity);
    }

    private boolean isBoat(Entity entity) {
        return entity instanceof Boat;
    }

    private boolean isPig(Entity entity) {
        return entity instanceof Pig;
    }

    private boolean isHorse(Entity entity) {
        return entity instanceof AbstractHorse;
    }

    public static enum TransitingMode {
        UP,
        DOWN;

    }
}

