/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EntityTexture {
    public static final EntityTexture EMPTY = new EntityTexture(null, null, null);
    private final EntityTextureDescriptor descriptor;
    private final String url;
    private final OpenResourceLocation location;
    private String modelType;
    @OnlyIn(value=Dist.CLIENT)
    private BakedEntityTexture texture;

    public EntityTexture(OpenResourceLocation location, String url, String modelType) {
        this(EntityTextureDescriptor.EMPTY, location, url, modelType);
    }

    public EntityTexture(EntityTextureDescriptor descriptor, OpenResourceLocation location, String url, String modelType) {
        this.descriptor = descriptor;
        this.location = location;
        this.modelType = modelType;
        this.url = url;
    }

    public String modelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public EntityTextureDescriptor descriptor() {
        return this.descriptor;
    }

    public OpenResourceLocation location() {
        return this.location;
    }

    public String url() {
        return this.url;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isDownloaded() {
        return this.texture != null && this.texture.isLoaded();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedEntityTexture texture() {
        if (this.texture != null && this.texture.isLoaded()) {
            return this.texture;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setTexture(BakedEntityTexture texture) {
        this.texture = texture;
    }
}

