/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.client.model.IModelPartPose;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.PlayerModel.Transformer;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.model.TransformModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class VillagerModelArmaturePlugin
extends ArmaturePlugin {
    private final IModelPart sourcePart;
    private final IModelPart destinationPart;
    private final TransformModel<LivingEntity> transformModelRef = new TransformModel(0.0f);

    public VillagerModelArmaturePlugin(ArmatureTransformerContext context) {
        IModel model = context.entityModel();
        Object transformModel = AbstractModelHolder.of(this.transformModelRef);
        this.sourcePart = model.partByName("head");
        this.destinationPart = transformModel.partByName("head");
        context.setEntityModel0((IModel)transformModel);
    }

    @Override
    public void activate(Entity entity, ArmaturePlugin.Context context) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Transformer.transformFrom(this.transformModelRef, livingEntity, context.partialTicks());
        if (this.sourcePart != null && this.destinationPart != null) {
            IModelPartPose src = this.sourcePart.pose();
            IModelPartPose dest = this.destinationPart.pose();
            dest.setRotation(src.xRot(), src.yRot(), src.zRot());
        }
    }
}

