/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.nio.FloatBuffer;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.utils.MatrixUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public abstract class ShaderUniform {
    protected final String name;
    protected final int program;
    protected final int location;

    ShaderUniform(String name, int program, int location) {
        this.name = name;
        this.program = program;
        this.location = location;
    }

    public abstract void apply();

    public void push() {
    }

    public void pop() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShaderUniform)) {
            return false;
        }
        ShaderUniform that = (ShaderUniform)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Matrix3f
    extends ShaderUniform {
        private final FloatBuffer buffer = MatrixUtils.createFloatBuffer(9);
        private final Supplier<OpenMatrix3f> value;
        private final OpenMatrix3f cachedValue = OpenMatrix3f.createScaleMatrix(0.0f, 0.0f, 0.0f);

        Matrix3f(String name, int program, int location, Supplier<OpenMatrix3f> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            OpenMatrix3f newValue = this.value.get();
            if (!newValue.equals(this.cachedValue)) {
                newValue.store(this.buffer);
                this.cachedValue.load(this.buffer);
                this.buffer.rewind();
                GL20.glUniformMatrix3fv((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
            }
        }
    }

    public static class Matrix4f
    extends ShaderUniform {
        private final FloatBuffer buffer = MatrixUtils.createFloatBuffer(16);
        private final Supplier<OpenMatrix4f> value;
        private final OpenMatrix4f cachedValue = OpenMatrix4f.createScaleMatrix(0.0f, 0.0f, 0.0f);

        Matrix4f(String name, int program, int location, Supplier<OpenMatrix4f> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            OpenMatrix4f newValue = this.value.get();
            if (!newValue.equals(this.cachedValue)) {
                newValue.store(this.buffer);
                this.cachedValue.load(this.buffer);
                this.buffer.rewind();
                GL20.glUniformMatrix4fv((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
            }
        }
    }

    public static class Vec4f
    extends ShaderUniform {
        private final Supplier<OpenVector4f> value;
        private OpenVector4f cachedValue = OpenVector4f.ZERO;

        Vec4f(String name, int program, int location, Supplier<OpenVector4f> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            OpenVector4f newValue = this.value.get();
            if (!newValue.equals(this.cachedValue)) {
                this.cachedValue = newValue;
                GL20.glUniform4f((int)this.location, (float)newValue.x(), (float)newValue.y(), (float)newValue.z(), (float)newValue.w());
            }
        }
    }

    public static class Int
    extends ShaderUniform {
        private final Supplier<Integer> value;
        private final Stack<Integer> cachedValues = new Stack();
        private int cachedValue = 0;

        Int(String name, int program, int location, Supplier<Integer> value) {
            super(name, program, location);
            this.value = value;
        }

        @Override
        public void apply() {
            int newValue = this.value.get();
            if (this.cachedValue != newValue) {
                this.cachedValue = newValue;
                GL20.glUniform1i((int)this.location, (int)newValue);
            }
        }

        @Override
        public void push() {
            this.cachedValues.push(this.cachedValue);
        }

        @Override
        public void pop() {
            int newValue;
            this.cachedValue = newValue = this.cachedValues.pop().intValue();
            GL20.glUniform1i((int)this.location, (int)newValue);
        }
    }
}

