/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.core.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.utils.RenderSystem;

public class ShaderContext {
    private static final ShaderContext INSTANCE = new ShaderContext();
    private final AbstractModelViewStack modelViewStack = AbstractModelViewStack.getInstance();
    private final AtomicInteger matrixFlags = new AtomicInteger();
    private final AtomicInteger scissorFlags = new AtomicInteger();
    private final Storage<OpenMatrix3f> objectNormalMatrix = new Storage<OpenMatrix3f>(OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private final Storage<OpenMatrix4f> objectViewMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private final Storage<OpenMatrix4f> textureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private final Storage<OpenMatrix4f> overlayTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private final Storage<OpenMatrix4f> lightmapTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private final Storage<OpenVector4f> colorModulator = new Storage<OpenVector4f>(OpenVector4f.ONE);
    private final Storage<OpenMatrix4f> modelViewMatrix = new Storage<Object>(null);

    public static ShaderContext getInstance() {
        return INSTANCE;
    }

    public void setObjectNormalMatrix(OpenMatrix3f value) {
        this.objectNormalMatrix.set(value);
    }

    public OpenMatrix3f objectNormalMatrix() {
        return this.objectNormalMatrix.get();
    }

    public void setObjectViewMatrix(OpenMatrix4f value) {
        this.objectViewMatrix.set(value);
    }

    public OpenMatrix4f objectViewMatrix() {
        return this.objectViewMatrix.get();
    }

    public void setTextureMatrix(OpenMatrix4f value) {
        this.textureMatrix.set(value);
    }

    public OpenMatrix4f textureMatrix() {
        return this.textureMatrix.get();
    }

    public void setOverlayTextureMatrix(OpenMatrix4f value) {
        this.overlayTextureMatrix.set(value);
    }

    public OpenMatrix4f overlayTextureMatrix() {
        return this.overlayTextureMatrix.get();
    }

    public void setLightmapTextureMatrix(OpenMatrix4f value) {
        this.lightmapTextureMatrix.set(value);
    }

    public OpenMatrix4f lightmapTextureMatrix() {
        return this.lightmapTextureMatrix.get();
    }

    public void setColorModulator(OpenVector4f value) {
        this.colorModulator.set(value);
    }

    public OpenVector4f colorModulator() {
        return this.colorModulator.get();
    }

    public void setMatrixFlags(int options) {
        this.matrixFlags.set(options);
    }

    public int matrixFlags() {
        return this.matrixFlags.get();
    }

    public void setScissorFlags(int flags) {
        this.scissorFlags.set(flags);
    }

    public int scissorFlags() {
        return this.scissorFlags.get();
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public void setModelViewMatrix(OpenMatrix4f value) {
        this.modelViewMatrix.set(value);
        this.modelViewStack.last().set(value);
        this.modelViewStack.apply();
    }

    public OpenMatrix4f modelViewMatrix() {
        return this.modelViewMatrix.get();
    }

    public void polygonMode(int face, int mode) {
        RenderSystem.polygonMode((int)face, (int)mode);
    }

    public void polygonOffset(float factor, float units) {
        RenderSystem.polygonOffset((float)factor, (float)units);
    }

    public void enablePolygonOffset() {
        RenderSystem.enablePolygonOffset();
    }

    public void disablePolygonOffset() {
        RenderSystem.disablePolygonOffset();
    }

    public void saveState() {
        this.modelViewStack.pushMatrix();
        this.modelViewMatrix.save();
        this.textureMatrix.save();
        this.objectNormalMatrix.save();
        this.lightmapTextureMatrix.save();
        this.objectViewMatrix.save();
    }

    public void restoreState() {
        this.textureMatrix.load();
        this.objectNormalMatrix.load();
        this.lightmapTextureMatrix.load();
        this.objectViewMatrix.load();
        this.modelViewMatrix.load();
        this.modelViewStack.popMatrix();
    }

    private static class Storage<T> {
        private T value;
        private T backup;

        public Storage(T value) {
            this.value = value;
            this.backup = value;
        }

        public void save() {
            this.backup = this.value;
        }

        public void load() {
            this.value = this.backup;
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }
    }
}

