/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractItemStackRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.resources.model.BakedModel.ABI;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinItemRenderer
extends AbstractItemStackRenderer {
    private static MannequinItemRenderer INSTANCE;

    public static MannequinItemRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MannequinItemRenderer();
        }
        return INSTANCE;
    }

    @Override
    public void renderByItem(ItemStack itemStack, OpenItemDisplayContext itemDisplayContext, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        if (itemStack.isEmpty()) {
            return;
        }
        BakedModel bakedModel = EnvironmentManager.getClient().getItemRenderer().getItemModelShaper().getItemModel(itemStack);
        ItemTransform transform = ABI.getTransform(bakedModel, itemDisplayContext);
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.of(itemStack);
        OpenVector3f rotation = new OpenVector3f(transform.rotation.x(), transform.rotation.y(), transform.rotation.z());
        ExtendedItemRenderer.renderMannequin(descriptor, rotation, 1.0f, 1.0f, 1.0f, 0.0f, light, poseStack, bufferSource);
        poseStack.popPose();
    }
}

