/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererLayerProvider;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractLivingEntityRenderer;
import moe.plushie.armourers_workshop.core.client.model.MannequinArmorModel;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinEntityRenderer<T extends MannequinEntity>
extends AbstractLivingEntityRenderer<T, MannequinModel<T>> {
    public static boolean enableLimitScale = false;
    public static boolean enableLimitYRot = false;
    private final AbstractEntityRendererProviderImpl.Context context;
    private final MannequinModel<T> normalModel;
    private final MannequinModel<T> slimModel;
    private final RenderLayer<T, MannequinModel<T>> normalArmorLayer;
    private final RenderLayer<T, MannequinModel<T>> slimArmorLayer;
    private MannequinEntityRenderer<T> mannequinRenderer;
    private OpenResourceLocation texture;
    private BakedEntityTexture bakedTexture;
    private EntityTextureDescriptor.Model textureModel = EntityTextureDescriptor.Model.STEVE;
    private boolean enableChildRenderer = false;

    public MannequinEntityRenderer(AbstractEntityRendererProviderImpl.Context context) {
        super(context, MannequinModel.normal(context), 0.0f);
        AbstractEntityRendererLayerProvider provider = this.getLayerProvider();
        this.context = context;
        this.normalModel = (MannequinModel)super.getModel();
        this.slimModel = MannequinModel.slim(context);
        this.normalArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.normalInner(context), MannequinArmorModel.normalOuter(context));
        this.slimArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.slimInner(context), MannequinArmorModel.slimOuter(context));
        this.addLayer(this.normalArmorLayer);
        this.addLayer(provider.createItemInHandLayer(context));
        this.addLayer(provider.createElytraLayer(context));
        this.addLayer(provider.createCustomHeadLayer(context));
    }

    public boolean shouldShowName(T entity) {
        return entity.hasCustomName();
    }

    @Override
    public void render(T entity, float f, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int packedLightIn) {
        if (this.enableChildRenderer) {
            this.getChildRenderer().render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
            return;
        }
        EntityTextureLoader textureLoader = EntityTextureLoader.getInstance();
        this.texture = textureLoader.getTextureLocation((Entity)entity);
        this.bakedTexture = textureLoader.getTextureModel(this.texture);
        this.applyTextureModel(((MannequinEntity)entity).getTextureModel());
        ((MannequinModel)super.getModel()).setAllVisible(((MannequinEntity)entity).isModelVisible());
        this.enableChildRenderer = true;
        super.render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
        this.enableChildRenderer = false;
        if (ModDebugger.mannequinCulling) {
            poseStack.pushPose();
            AABB box = ((MannequinEntity)entity).getBoundingBoxForCulling();
            double tx = -box.minX - (box.maxX - box.minX) / 2.0;
            double ty = -box.minY;
            double tz = -box.minZ - (box.maxZ - box.minZ) / 2.0;
            poseStack.translate((float)tx, (float)ty, (float)tz);
            ShapeTesselator.stroke(box, UIColor.YELLOW, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    @Override
    public float getEntityScale(T entity) {
        float f = 0.9375f;
        if (!enableLimitScale) {
            f *= ((MannequinEntity)entity).getScale();
        }
        return f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (this.texture != null) {
            return this.texture.toLocation();
        }
        return ModTextures.MANNEQUIN_DEFAULT.toLocation();
    }

    public MannequinEntityRenderer<T> getChildRenderer() {
        if (this.mannequinRenderer == null) {
            this.mannequinRenderer = new MannequinEntityRenderer<T>(this.context);
        }
        return this.mannequinRenderer;
    }

    private void applyTextureModel(EntityTextureDescriptor.Model newValue) {
        if (this.textureModel == newValue) {
            return;
        }
        this.textureModel = newValue;
        if (newValue == EntityTextureDescriptor.Model.STEVE) {
            this.setModel(this.normalModel);
            this.replaceTo(this.slimArmorLayer, this.normalArmorLayer);
        } else {
            this.setModel(this.slimModel);
            this.replaceTo(this.normalArmorLayer, this.slimArmorLayer);
        }
    }

    private void replaceTo(RenderLayer<T, MannequinModel<T>> fromLayer, RenderLayer<T, MannequinModel<T>> toLayer) {
        int index = this.layers.indexOf(fromLayer);
        if (index >= 0) {
            RenderLayer<T, MannequinModel<T>> renderLayer = this.layers.set(index, toLayer);
        }
    }
}

