/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighlightPlacementRenderer {
    public static void renderBlock(ItemStack itemStack, Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.type() != SkinTypes.BLOCK) {
            return;
        }
        poseStack.pushPose();
        float f = 0.0625f;
        Vec3 origin = renderInfo.getPosition();
        SkinBlockPlaceContext context = new SkinBlockPlaceContext(player, InteractionHand.MAIN_HAND, itemStack, traceResult);
        BlockPos location = context.getClickedPos();
        poseStack.translate((float)location.getX() - (float)origin.x(), (float)location.getY() - (float)origin.y(), (float)location.getZ() - (float)origin.z());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(f, f, f);
        for (SkinBlockPlaceContext.Part part : context.parts()) {
            BlockPos pos = part.offset();
            UIColor color = UIColor.RED;
            if (context.canPlace(part)) {
                color = UIColor.WHITE;
            }
            poseStack.pushPose();
            poseStack.translate((float)pos.getX() * 16.0f, (float)pos.getY() * 16.0f, (float)pos.getZ() * 16.0f);
            ShapeTesselator.stroke((IRectangle3i)part.shape(), color, poseStack, bufferSource);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static void renderEntity(Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        Vec3 origin = renderInfo.getPosition();
        MannequinHitResult target = MannequinHitResult.test(player, origin, traceResult.getLocation(), traceResult.getBlockPos());
        poseStack.pushPose();
        Vec3 location = target.getLocation();
        poseStack.translate((float)(location.x() - origin.x()), (float)(location.y() - origin.y()), (float)(location.z() - origin.z()));
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(-target.rotation()));
        MannequinModel<?> model = SkinItemRenderer.getInstance().mannequinModel();
        if (model != null) {
            float f = target.scale() * 0.9375f;
            MultiBufferSource buffers1 = AbstractBufferSource.unwrap(bufferSource);
            VertexConsumer builder = buffers1.getBuffer((RenderType)SkinRenderType.HIGHLIGHTED_ENTITY_LINES.get());
            poseStack.pushPose();
            poseStack.scale(f, f, f);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0f, -1.501f, 0.0f);
            model.renderToBuffer(AbstractPoseStack.unwrap(poseStack), builder, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

