/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlaceholderManager {
    private static final int PLACEHOLDER_ENTITY_ID = -1021;
    public static final Supplier<MannequinEntity> MANNEQUIN = new LazyEntry<MannequinEntity>(level -> {
        MannequinEntity entity = new MannequinEntity((EntityType<? extends MannequinEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), (Level)level);
        entity.setExtraRenderer(false);
        return entity;
    });

    public static boolean isPlaceholder(Entity entity) {
        if (entity != null) {
            return entity.getId() == -1021;
        }
        return false;
    }

    private static class LazyEntry<T extends Entity>
    implements Supplier<T> {
        private T entity;
        private final Function<Level, T> provider;

        private LazyEntry(Function<Level, T> provider) {
            this.provider = provider;
        }

        @Override
        public T get() {
            ClientLevel level = EnvironmentManager.getClient().level;
            if (this.entity == null) {
                this.entity = (Entity)this.provider.apply((Level)level);
                this.entity.setId(-1021);
            }
            if (PropertyProvider.getLevel(this.entity) != level) {
                this.entity.setLevel((Level)level);
            }
            return this.entity;
        }
    }
}

