/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractPlayerModel;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.render.MannequinEntityRenderer;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import net.minecraft.core.Rotations;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinModel<T extends MannequinEntity>
extends AbstractPlayerModel<T> {
    private Rotations mainPose;

    public MannequinModel(AbstractEntityRendererProviderImpl.Context context, float scale, AbstractPlayerModel.Type type) {
        super(context, scale, type);
    }

    public static <T extends MannequinEntity> MannequinModel<T> placeholder() {
        return MannequinModel.normal(AbstractEntityRendererProviderImpl.Context.sharedContext());
    }

    public static <T extends MannequinEntity> MannequinModel<T> normal(AbstractEntityRendererProviderImpl.Context context) {
        return new MannequinModel<T>(context, 0.0f, AbstractPlayerModel.Type.NORMAL);
    }

    public static <T extends MannequinEntity> MannequinModel<T> slim(AbstractEntityRendererProviderImpl.Context context) {
        return new MannequinModel<T>(context, 0.0f, AbstractPlayerModel.Type.SLIM);
    }

    public void setupAnim(T entity, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        this.head.xRot = OpenMath.toRadians(entity.getHeadPose().getX());
        this.head.yRot = OpenMath.toRadians(entity.getHeadPose().getY());
        this.head.zRot = OpenMath.toRadians(entity.getHeadPose().getZ());
        this.leftArm.xRot = OpenMath.toRadians(entity.getLeftArmPose().getX());
        this.leftArm.yRot = OpenMath.toRadians(entity.getLeftArmPose().getY());
        this.leftArm.zRot = OpenMath.toRadians(entity.getLeftArmPose().getZ());
        this.rightArm.xRot = OpenMath.toRadians(entity.getRightArmPose().getX());
        this.rightArm.yRot = OpenMath.toRadians(entity.getRightArmPose().getY());
        this.rightArm.zRot = OpenMath.toRadians(entity.getRightArmPose().getZ());
        this.leftLeg.xRot = OpenMath.toRadians(entity.getLeftLegPose().getX());
        this.leftLeg.yRot = OpenMath.toRadians(entity.getLeftLegPose().getY());
        this.leftLeg.zRot = OpenMath.toRadians(entity.getLeftLegPose().getZ());
        this.rightLeg.xRot = OpenMath.toRadians(entity.getRightLegPose().getX());
        this.rightLeg.yRot = OpenMath.toRadians(entity.getRightLegPose().getY());
        this.rightLeg.zRot = OpenMath.toRadians(entity.getRightLegPose().getZ());
        this.hat.copyFrom(this.head);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        this.mainPose = entity.getBodyPose();
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer builder, int light, int overlay, int color) {
        float rx = this.mainPose.getX();
        float ry = this.mainPose.getY();
        float rz = this.mainPose.getZ();
        if (MannequinEntityRenderer.enableLimitYRot) {
            ry = 0.0f;
        }
        ABI.mulPose(poseStack, new OpenQuaternionf(rx, ry, rz, true));
        super.renderToBuffer(poseStack, builder, light, overlay, color);
    }
}

