/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.layer;

import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.client.AbstractModelViewStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderLayer;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelHolder;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.OutlineColor;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EpicFightEntityRendererPatch;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeLayer<T extends Entity, V extends EntityModel<T>, M extends IModel>
extends AbstractRenderLayer<T, V> {
    protected final BakedArmature armature;
    protected final RenderLayerParent<T, V> entityRenderer;

    public SkinWardrobeLayer(BakedArmatureTransformer armatureTransformer, RenderLayerParent<T, V> renderer) {
        super(renderer);
        this.armature = new BakedArmature(armatureTransformer.armature());
        this.entityRenderer = renderer;
    }

    @Override
    public void render(T entity, float limbSwing, float limbSwingAmount, int packedLightIn, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, IPoseStack poseStack, IBufferSource bufferSource) {
        if (entity.isInvisible()) {
            return;
        }
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        List<EntitySlot> renderingTasks = renderData.armorSkins();
        if (renderingTasks.isEmpty()) {
            return;
        }
        EntityRenderPatch<? super Entity> renderPatch = renderData.renderPatch();
        if (renderPatch == null) {
            return;
        }
        BakedArmatureTransformer transformer = renderPatch.transformer();
        if (transformer == null) {
            return;
        }
        IPoseStack poseStack1 = poseStack;
        EpicFightEntityRendererPatch epicFlightContext = Objects.safeCast(renderPatch, EpicFightEntityRendererPatch.class);
        if (epicFlightContext != null) {
            poseStack = epicFlightContext.overridePose();
        }
        poseStack.pushPose();
        if (epicFlightContext == null) {
            this.applyModelScale(poseStack, AbstractModelHolder.of((Model)this.getParentModel()));
        }
        float f = 0.0625f;
        poseStack.scale(f, f, f);
        transformer.applyTo(this.armature);
        DefaultArmaturePluginContext pluginContext = renderPatch.pluginContext();
        SkinRenderContext renderingContext = renderPatch.renderingContext();
        renderingContext.setOverlay(pluginContext.overlay());
        renderingContext.setLightmap(pluginContext.lightmap());
        renderingContext.setPartialTicks(pluginContext.partialTicks());
        renderingContext.setAnimationTicks(pluginContext.animationTicks());
        renderingContext.setPoseStack(poseStack);
        renderingContext.setBufferSource(bufferSource);
        renderingContext.setModelViewStack(AbstractModelViewStack.getInstance());
        renderingContext.setOutlineColor(OutlineColor.getOutlineColor(entity));
        for (EntitySlot entry : renderingTasks) {
            renderingContext.setOverlay(entry.getOverrideOverlay((Entity)entity));
            renderingContext.setItemSource(SkinItemSource.create(entry.renderPriority(), entry.itemStack()));
            BakedSkin bakedSkin = entry.skin();
            bakedSkin.setupAnim((Entity)entity, this.armature, renderingContext);
            SkinPaintScheme paintScheme = bakedSkin.resolve((Entity)entity, entry.paintScheme());
            SkinRenderer.render(entity, this.armature, bakedSkin, paintScheme, renderingContext);
        }
        poseStack.popPose();
    }

    protected void applyModelScale(IPoseStack poseStack, M model) {
        IModelBabyPose babyPose = model.babyPose();
        if (babyPose != null) {
            float scale = 1.0f / babyPose.headScale();
            IVector3f offset = babyPose.headOffset();
            poseStack.scale(scale, scale, scale);
            poseStack.translate(offset.x() / 16.0f, offset.y() / 16.0f, offset.z() / 16.0f);
        }
    }
}

