/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlotListView<M extends AbstractContainerMenu>
extends UIView {
    protected final M menu;
    protected final DelegateScreen<M> screen;
    private boolean isReady = false;

    public SlotListView(M menu, Inventory inventory, CGRect frame) {
        super(frame);
        this.menu = menu;
        this.screen = new DelegateScreen<M>(menu, inventory, (Component)Component.literal((String)""));
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        UIWindow window = this.window();
        if (window != null) {
            this.screen.setup(this.convertRectToView(this.bounds(), null), window.bounds());
            this.isReady = true;
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        if (!this.isReady) {
            return;
        }
        int mouseX = (int)context.state().mousePos().x();
        int mouseY = (int)context.state().mousePos().y();
        CGPoint offset = this.screen.contentOffset();
        context.saveGraphicsState();
        context.translateCTM(-offset.x, -offset.y, 0.0f);
        this.screen.renderInView(this, 400, mouseX, mouseY, context.state().partialTicks(), context);
        context.restoreGraphicsState();
    }

    @Override
    public void mouseDown(UIEvent event) {
        CGPoint point = this.locationInScreen(event);
        this.screen.mouseClicked(point.x, point.y, event.key());
    }

    @Override
    public void mouseUp(UIEvent event) {
        CGPoint point = this.locationInScreen(event);
        this.screen.mouseReleased(point.x, point.y, event.key());
    }

    @Override
    public void removeFromSuperview() {
        super.removeFromSuperview();
        this.screen.removed();
    }

    public M menu() {
        return this.menu;
    }

    private CGPoint locationInScreen(UIEvent event) {
        CGPoint point = event.locationInWindow();
        UIWindow window = this.window();
        if (window != null) {
            CGRect frame = window.frame();
            return new CGPoint(point.x + frame.x, point.y + frame.y);
        }
        return point;
    }

    public static class DelegateScreen<M extends AbstractContainerMenu>
    extends AbstractMenuScreen<M> {
        private final Inventory inventory;

        public DelegateScreen(M menu, Inventory inventory, Component component) {
            super(menu, inventory, component);
            this.inventory = inventory;
            this.init(EnvironmentManager.getClient(), 640, 480);
        }

        @Override
        public void onClose() {
        }

        public void setup(CGRect rect, CGRect bounds) {
            this.setContentSize(new CGSize(rect.width, rect.height));
            this.resize(EnvironmentManager.getClient(), (int)bounds.width, (int)bounds.height);
            this.setContentOffset(new CGPoint(rect.x, rect.y));
        }

        @Override
        public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
        }

        public void slotClicked(Slot slot, int i, int j, ClickType clickType) {
            if (slot != null) {
                this.menu.clicked(slot.index, j, clickType, this.inventory.player);
            }
        }
    }
}

