/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.StateValueImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.core.Rotations;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityPartView
extends UIControl {
    private final StateValueImpl<UIColor> partColor = new StateValueImpl();
    private final UIImage backgroundImage = UIImage.of(ModTextures.WARDROBE_2).uv(22.0f, 0.0f).build();
    private Part selectedPart;
    private Part highlightedPart;

    public EntityPartView(CGRect frame) {
        super(frame);
        this.partColor.setValueForState(UIColor.of(-855638272), 0);
        this.partColor.setValueForState(UIColor.of(-855638017), 1);
        this.partColor.setValueForState(UIColor.of(-872349952), 2);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        Part part = this.getPart(event.locationInView(this));
        if (part != null) {
            this.selectedPart = part;
            this.sendEvent(UIControl.Event.VALUE_CHANGED);
        }
    }

    @Override
    public void mouseMoved(UIEvent event) {
        super.mouseMoved(event);
        this.highlightedPart = this.getPart(event.locationInView(this));
    }

    @Override
    public void mouseExited(UIEvent event) {
        super.mouseExited(event);
        this.highlightedPart = null;
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        context.drawImage(this.backgroundImage, this.bounds());
        for (Part part : Part.values()) {
            context.fillRect(part.bounds, this.partColor.valueForState(this.getPartState(part)));
        }
    }

    public Part selectedPart() {
        return this.selectedPart;
    }

    public void setSelectedPart(Part selectedPart) {
        this.selectedPart = selectedPart;
    }

    private Part getPart(CGPoint point) {
        for (Part part : Part.values()) {
            if (!part.bounds.contains(point)) continue;
            return part;
        }
        return null;
    }

    private int getPartState(Part part) {
        if (part == this.selectedPart) {
            return 2;
        }
        if (part == this.highlightedPart) {
            return 1;
        }
        return 0;
    }

    public static enum Part {
        HEAD("Head", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_HEAD_POSE, MannequinEntity.DEFAULT_HEAD_POSE, 8, 3, 8, 8),
        BODY("Body", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_BODY_POSE, MannequinEntity.DEFAULT_BODY_POSE, 8, 12, 8, 12),
        RIGHT_ARM("RightArm", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_RIGHT_ARM_POSE, MannequinEntity.DEFAULT_RIGHT_ARM_POSE, 3, 12, 4, 12),
        LEFT_ARM("LeftArm", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_LEFT_ARM_POSE, MannequinEntity.DEFAULT_LEFT_ARM_POSE, 17, 12, 4, 12),
        RIGHT_LEG("RightLeg", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_RIGHT_LEG_POSE, MannequinEntity.DEFAULT_RIGHT_LEG_POSE, 7, 25, 4, 12),
        LEFT_LEG("LeftLeg", (EntityDataAccessor<Rotations>)MannequinEntity.DATA_LEFT_LEG_POSE, MannequinEntity.DEFAULT_LEFT_LEG_POSE, 13, 25, 4, 12);

        public final String name;
        public final CGRect bounds;
        public final Rotations defaultValue;
        public final EntityDataAccessor<Rotations> dataParameter;

        private Part(String name, EntityDataAccessor<Rotations> dataParameter, Rotations defaultValue, int x, int y, int width, int height) {
            this.name = name;
            this.bounds = new CGRect(x, y, width, height);
            this.dataParameter = dataParameter;
            this.defaultValue = defaultValue;
        }

        public void setValue(Entity entity, Rotations value) {
            entity.getEntityData().set(this.dataParameter, (Object)value);
        }

        public Rotations getValue(Entity entity) {
            if (entity == null) {
                return this.defaultValue;
            }
            return (Rotations)entity.getEntityData().get(this.dataParameter);
        }
    }
}

