/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.hologramprojector;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.client.gui.hologramprojector.HologramProjectorBaseSetting;
import moe.plushie.armourers_workshop.core.network.UpdateHologramProjectorPacket;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorExtraSetting
extends HologramProjectorBaseSetting {
    private final HologramProjectorBlockEntity entity;

    public HologramProjectorExtraSetting(HologramProjectorBlockEntity entity) {
        super("hologram-projector.extra");
        this.entity = entity;
        this.setFrame(new CGRect(0.0f, 0.0f, 200.0f, 78.0f));
        this.setup();
    }

    private void setup() {
        this.setupOption(11, 30, UpdateHologramProjectorPacket.Field.IS_GLOWING, "glowing");
        this.setupComboList(11, 55, UpdateHologramProjectorPacket.Field.POWER_MODE);
        UILabel label = new UILabel(new CGRect(11.0f, 45.0f, 178.0f, 9.0f));
        label.setText(this.getDisplayText("powerMode", new Object[0]));
        this.addSubview(label);
    }

    private void setupOption(int x, int y, UpdateHologramProjectorPacket.Field<Boolean> property, String key) {
        UICheckBox checkBox = new UICheckBox(new CGRect(x, y, 178.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(key, new Object[0]));
        checkBox.setSelected((Boolean)property.get(this.entity));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)Objects.unsafeCast(c);
            property.set(this.entity, checkBox1.isSelected());
            NetworkManager.sendToServer(property.buildPacket(this.entity, checkBox1.isSelected()));
        });
        this.addSubview(checkBox);
    }

    private void setupComboList(int x, int y, UpdateHologramProjectorPacket.Field<Integer> property) {
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        items.add(new UIComboItem(this.getDisplayText("powerMode.ignored", new Object[0])));
        items.add(new UIComboItem(this.getDisplayText("powerMode.high", new Object[0])));
        items.add(new UIComboItem(this.getDisplayText("powerMode.low", new Object[0])));
        UIComboBox comboBox = new UIComboBox(new CGRect(x, y, 80.0f, 14.0f));
        comboBox.setSelectedIndex((Integer)property.get(this.entity));
        comboBox.reloadData(items);
        comboBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, e) -> {
            UIComboBox comboBox1 = (UIComboBox)Objects.unsafeCast(e);
            property.set(this.entity, comboBox1.selectedIndex());
            NetworkManager.sendToServer(property.buildPacket(this.entity, comboBox1.selectedIndex()));
        });
        this.addSubview(comboBox);
    }
}

