/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.data.EntityCollisionContainer;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobe
implements IDataSerializable.Mutable {
    private final BitSet flags = new BitSet(6);
    private final HashMap<SkinSlotType, Integer> skinSlots = new HashMap();
    private final SimpleContainer inventory = new SimpleContainer(SkinSlotType.getTotalSize());
    private final EntityCollisionContainer collision;
    private final WeakReference<Entity> entity;
    private int id;
    private EntityProfile profile;

    public SkinWardrobe(Entity entity, EntityProfile profile) {
        this.id = entity.getId();
        this.entity = new WeakReference<Entity>(entity);
        this.collision = new EntityCollisionContainer(this.inventory, entity);
        this.profile = profile;
    }

    @Nullable
    public static SkinWardrobe of(@Nullable Entity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).wardrobe().orElse(null);
        }
        return null;
    }

    public static Optional<SkinWardrobe> create(Entity entity) {
        EntityProfile profile = ModEntityProfiles.getProfile(entity);
        if (profile != null) {
            return Optional.of(new SkinWardrobe(entity, profile));
        }
        return Optional.empty();
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        SkinWardrobeStorage.saveSkinSlots(this.skinSlots, serializer);
        SkinWardrobeStorage.saveFlags(this.flags, serializer);
        SkinWardrobeStorage.saveInventoryItems((Container)this.inventory, serializer);
        SkinWardrobeStorage.saveBoundingBox(this.collision, serializer);
        SkinWardrobeStorage.saveDataFixer(this, serializer);
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.collision.beginUpdates();
        SkinWardrobeStorage.loadSkinSlots(this.skinSlots, serializer);
        SkinWardrobeStorage.loadFlags(this.flags, serializer);
        SkinWardrobeStorage.loadInventoryItems((Container)this.inventory, serializer);
        SkinWardrobeStorage.loadBoundingBox(this.collision, this, serializer);
        SkinWardrobeStorage.loadDataFixer(this, serializer);
        this.collision.endUpdates();
    }

    public void setProfile(EntityProfile profile) {
        this.profile = profile;
    }

    public EntityProfile profile() {
        return this.profile;
    }

    public int getFreeSlot(SkinSlotType slotType) {
        int unlockedSize = this.getUnlockedSize(slotType);
        for (int i = 0; i < unlockedSize; ++i) {
            if (!this.inventory.getItem(slotType.index() + i).isEmpty()) continue;
            return i;
        }
        return unlockedSize - 1;
    }

    public ItemStack getItem(SkinSlotType slotType, int slot) {
        if (slot < 0 || slot >= this.getUnlockedSize(slotType)) {
            return ItemStack.EMPTY;
        }
        return this.inventory.getItem(slotType.index() + slot);
    }

    public void setItem(SkinSlotType slotType, int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.getUnlockedSize(slotType)) {
            return;
        }
        this.inventory.setItem(slotType.index() + slot, itemStack);
    }

    public void dropAll(@Nullable Consumer<ItemStack> consumer) {
        int containerSize = this.inventory.getContainerSize();
        int ignoredStart = SkinSlotType.DYE.index() + 8;
        int ignoredEnd = SkinSlotType.DYE.index() + SkinSlotType.DYE.maxSize();
        for (int i = 0; i < containerSize; ++i) {
            ItemStack itemStack;
            if (i >= ignoredStart && i < ignoredEnd || (itemStack = this.inventory.getItem(i)).isEmpty()) continue;
            if (consumer != null) {
                consumer.accept(itemStack);
            }
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public void clear() {
        this.inventory.clearContent();
    }

    public void sendToServer() {
        NetworkManager.sendToServer(UpdateWardrobePacket.sync(this));
    }

    public void broadcast() {
        NetworkManager.sendToTracking(UpdateWardrobePacket.sync(this), this.entity());
    }

    public void broadcast(ServerPlayer player) {
        NetworkManager.sendTo(UpdateWardrobePacket.sync(this), player);
    }

    public void setCollisionShape(EntityCollisionShape shape) {
        this.collision.setResult(shape);
    }

    public EntityCollisionShape collisionShape() {
        return this.collision.result();
    }

    public boolean shouldRenderEquipment(OpenEquipmentSlot slotType) {
        return !this.flags.get(slotType.filterFlag());
    }

    public void setRenderEquipment(OpenEquipmentSlot slotType, boolean enable) {
        if (enable) {
            this.flags.clear(slotType.filterFlag());
        } else {
            this.flags.set(slotType.filterFlag());
        }
    }

    public boolean shouldRenderExtra() {
        return !this.flags.get(6);
    }

    public void setRenderExtra(boolean value) {
        if (value) {
            this.flags.clear(6);
        } else {
            this.flags.set(6);
        }
    }

    public BitSet flags() {
        return this.flags;
    }

    public void setUnlockedSize(SkinSlotType slotType, int size) {
        if (slotType != SkinSlotType.DYE) {
            this.skinSlots.put(slotType, size);
        }
    }

    public int getUnlockedSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        Integer modifiedSize = this.skinSlots.get((Object)slotType);
        if (modifiedSize != null) {
            return Math.min(slotType.maxSize(), modifiedSize);
        }
        return Math.min(slotType.maxSize(), this.profile.getMaxCount(slotType));
    }

    public int getMaximumSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        return slotType.maxSize();
    }

    public Container inventory() {
        return this.inventory;
    }

    @Nullable
    public Entity entity() {
        return (Entity)this.entity.get();
    }

    public int id() {
        Entity entity = this.entity();
        if (entity != null) {
            this.id = entity.getId();
        }
        return this.id;
    }

    public boolean isEditable(Player player) {
        if (!ModPermissions.OPEN.accept((IMenuType)ModMenuTypes.WARDROBE.get(), this.entity(), player)) {
            return false;
        }
        Entity entity = this.entity();
        if (entity instanceof Player && entity.getId() != player.getId()) {
            return false;
        }
        if (!ModConfig.Common.canOpenWardrobe(entity, player)) {
            return false;
        }
        return !this.profile().isLocked();
    }

    public boolean isSupported(SkinSlotType slotType) {
        return this.profile.isSupported(slotType);
    }
}

