/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import moe.plushie.armourers_workshop.api.common.IHasInventory;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UpdatableContainerBlockEntity
extends UpdatableBlockEntity
implements Container,
IHasInventory {
    public UpdatableContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public boolean isEmpty() {
        return this.getContainer().isEmpty();
    }

    public ItemStack getItem(int i) {
        return this.getContainer().getItem(i);
    }

    public ItemStack removeItem(int i, int j) {
        ItemStack itemStack = this.getContainer().removeItem(i, j);
        if (!itemStack.isEmpty()) {
            this.setContainerChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return this.getContainer().removeItemNoUpdate(i);
    }

    public void setItem(int i, ItemStack itemStack) {
        this.getContainer().setItem(i, itemStack);
        this.setContainerChanged();
    }

    public boolean stillValid(Player player) {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        BlockPos pos = this.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != this) {
            return false;
        }
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.getContainer().clearContent();
        this.setContainerChanged();
    }

    public int getContainerSize() {
        return this.getContainer().getContainerSize();
    }

    protected abstract SimpleContainer getContainer();

    protected void setContainerChanged() {
        this.setChanged();
    }

    @Override
    public Container getInventory() {
        return this;
    }
}

