/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.ITickable;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.block.SkinnableBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlockEntity
extends RotableContainerBlockEntity
implements ITickable {
    private static final Map<?, OpenVector3f> FACING_TO_ROT = Collections.immutableMap(it -> {
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.EAST), (Object)new OpenVector3f(180.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.NORTH), (Object)new OpenVector3f(180.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.WEST), (Object)new OpenVector3f(180.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.SOUTH), (Object)new OpenVector3f(180.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.EAST), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.SOUTH), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.WEST), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.NORTH), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.EAST), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.SOUTH), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.WEST), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.NORTH), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
    });
    private BlockPos reference = BlockPos.ZERO;
    private OpenRectangle3i collisionShape = OpenRectangle3i.ZERO;
    private SimpleContainer container;
    private List<BlockPos> refers;
    private List<SkinMarker> markers;
    private GlobalPos linkedPos = null;
    private SkinProperties properties;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private OpenQuaternionf renderRotations;
    private AABB renderBoundingBox;
    private VoxelShape cachedRenderShape = null;
    private VoxelShape cachedCollisionShape = null;
    private ItemStack droppedStack = null;
    private LinkedSnapshot lastSnapshot;
    private int callDepth = 0;
    private boolean isParent = false;

    public SkinnableBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static OpenVector3f getRotations(BlockState state) {
        AttachFace face = state.getOptionalValue((Property)SkinnableBlock.FACE).orElse(AttachFace.FLOOR);
        Direction facing = state.getOptionalValue((Property)SkinnableBlock.FACING).orElse(Direction.NORTH);
        return FACING_TO_ROT.getOrDefault(Pair.of((Object)face, (Object)facing), OpenVector3f.ZERO);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.reference = serializer.read(CodingKeys.REFERENCE);
        this.collisionShape = serializer.read(CodingKeys.SHAPE);
        this.cachedRenderShape = null;
        this.cachedCollisionShape = null;
        this.isParent = BlockPos.ZERO.equals((Object)this.reference);
        if (!this.isParent()) {
            return;
        }
        SkinProperties oldProperties = this.properties;
        this.refers = serializer.read(CodingKeys.REFERENCES);
        this.markers = serializer.read(CodingKeys.MARKERS);
        this.skin = serializer.read(CodingKeys.SKIN);
        this.properties = serializer.read(CodingKeys.SKIN_PROPERTIES);
        this.linkedPos = serializer.read(CodingKeys.LINKED_POS);
        if (oldProperties != null) {
            oldProperties.clear();
            oldProperties.putAll(this.properties);
            this.properties = oldProperties;
        }
        this.getOrCreateItems().deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFERENCE, this.reference);
        serializer.write(CodingKeys.SHAPE, this.collisionShape);
        if (!this.isParent()) {
            return;
        }
        serializer.write(CodingKeys.REFERENCES, this.refers);
        serializer.write(CodingKeys.MARKERS, this.markers);
        serializer.write(CodingKeys.SKIN, this.skin);
        serializer.write(CodingKeys.SKIN_PROPERTIES, this.properties);
        serializer.write(CodingKeys.LINKED_POS, this.linkedPos);
        this.getOrCreateItems().serialize(serializer);
    }

    @Override
    public void tick() {
        if (this.isParent()) {
            this.parentTick();
        } else {
            this.childTick();
        }
    }

    protected void parentTick() {
        LinkedSnapshot snapshot = this.makeLinkedSnapshot();
        if (!Objects.equals(this.lastSnapshot, snapshot)) {
            this.updateStateAndNeighbors();
            this.lastSnapshot = snapshot;
        }
    }

    protected void childTick() {
        Level level = this.getLevel();
        SkinnableBlockEntity parent = this.getParent();
        if (parent == null && level != null && !level.isClientSide()) {
            ModLog.warn("found a zombie block at {}, destroy it.", this.getBlockPos());
            this.kill();
        }
    }

    public void updateBlockStates() {
        this.setChanged();
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public void updateStateAndNeighbors() {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
            level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public void setSkin(SkinDescriptor skin) {
        this.skin = skin;
    }

    public SkinDescriptor getSkin() {
        if (this.isParent()) {
            return this.skin;
        }
        return SkinDescriptor.EMPTY;
    }

    public VoxelShape getShape() {
        if (this.cachedRenderShape != null) {
            return this.cachedRenderShape;
        }
        this.cachedRenderShape = this.calcCollisionShape();
        return this.cachedRenderShape;
    }

    public VoxelShape getCollisionShape() {
        if (this.noCollision()) {
            return Shapes.empty();
        }
        if (this.cachedCollisionShape != null) {
            return this.cachedCollisionShape;
        }
        this.cachedCollisionShape = this.calcCollisionShape();
        return this.cachedCollisionShape;
    }

    public void setLinkedPos(GlobalPos pos) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            blockEntity.linkedPos = pos;
            blockEntity.updateBlockStates();
            blockEntity.updateStateAndNeighbors();
        }
    }

    public GlobalPos getLinkedPos() {
        return this.getValueFromParent(te -> te.linkedPos).orElse(null);
    }

    public void kill() {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
    }

    @Override
    public int getContainerSize() {
        return 81;
    }

    @Override
    protected SimpleContainer getContainer() {
        return this.getOrCreateItems();
    }

    @Nullable
    public String getInventoryName() {
        return this.getProperty(SkinProperty.ALL_CUSTOM_NAME);
    }

    @Override
    @Nullable
    public Container getInventory() {
        return this.getParent();
    }

    public int getAnalogOutputSignal() {
        return this.getLinkedValueFromParent((level, pos) -> level.getBlockState(pos).getAnalogOutputSignal(level, pos)).orElse(0);
    }

    public int getSignal(Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.getBlockState(pos).getSignal((BlockGetter)level, pos, dir)).orElse(0);
    }

    public int getDirectSignal(Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.getBlockState(pos).getDirectSignal((BlockGetter)level, pos, dir)).orElse(0);
    }

    public Collection<BlockPos> getRefers() {
        if (this.refers == null) {
            this.refers = this.getValueFromParent(te -> te.refers).orElse(null);
        }
        if (this.refers == null) {
            return Collections.emptyList();
        }
        return this.refers;
    }

    public BlockPos getParentPos() {
        return this.getBlockPos().subtract((Vec3i)this.reference);
    }

    public OpenVector3d getSeatPos() {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers != null && !markers.isEmpty()) {
            SkinMarker marker = markers.iterator().next();
            dx = (float)marker.x / 16.0f;
            dy = (float)marker.y / 16.0f;
            dz = (float)marker.z / 16.0f;
        }
        return new OpenVector3d((float)parentPos.getX() + dx, (float)parentPos.getY() + dy, (float)parentPos.getZ() + dz);
    }

    public BlockPos getBedPos() {
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers == null || markers.isEmpty()) {
            Direction facing = this.getBlockState().getOptionalValue((Property)SkinnableBlock.FACING).orElse(Direction.NORTH);
            return parentPos.relative(Rotation.CLOCKWISE_180.rotate(facing));
        }
        SkinMarker marker = markers.iterator().next();
        return parentPos.offset(marker.x / 16, marker.y / 16, marker.z / 16);
    }

    public Collection<SkinMarker> getMarkers() {
        if (this.markers == null) {
            this.markers = this.getValueFromParent(te -> te.markers).orElse(null);
        }
        return this.markers;
    }

    @Nullable
    public SkinProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.getValueFromParent(te -> te.properties).orElse(null);
        }
        return this.properties;
    }

    @Nullable
    public SkinnableBlockEntity getParent() {
        if (this.isParent()) {
            return this;
        }
        if (this.getLevel() != null) {
            return Objects.safeCast(this.getLevel().getBlockEntity(this.getParentPos()), SkinnableBlockEntity.class);
        }
        return null;
    }

    public void setDropped(ItemStack itemStack) {
        this.droppedStack = itemStack;
    }

    public ItemStack getDropped() {
        return this.droppedStack;
    }

    public boolean isDropped() {
        return this.droppedStack != null;
    }

    public boolean isLadder() {
        return this.getProperty(SkinProperty.BLOCK_LADDER);
    }

    public boolean isEmissive() {
        return this.getProperty(SkinProperty.BLOCK_GLOWING);
    }

    public boolean isSeat() {
        return this.getProperty(SkinProperty.BLOCK_SEAT);
    }

    public boolean isBed() {
        return this.getProperty(SkinProperty.BLOCK_BED);
    }

    public boolean isLinked() {
        return this.getLinkedPos() != null;
    }

    public boolean isInventory() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY) != false || this.isEnderInventory();
    }

    public boolean isEnderInventory() {
        return this.getProperty(SkinProperty.BLOCK_ENDER_INVENTORY);
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean noCollision() {
        return this.getProperty(SkinProperty.BLOCK_NO_COLLISION);
    }

    public int getInventoryWidth() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_WIDTH);
    }

    public int getInventoryHeight() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_HEIGHT);
    }

    @Override
    @Nullable
    public <T> T getCapability(IBlockEntityCapability<T> capability, @Nullable Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> {
            BlockState state = level.getBlockState(pos);
            BlockEntity entity = level.getBlockEntity(pos);
            return capability.get((Level)level, (BlockPos)pos, state, entity, dir);
        }).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        OpenVector3f r = SkinnableBlockEntity.getRotations(blockState);
        this.renderRotations = new OpenQuaternionf(r.x(), r.y(), r.z(), true);
        return this.renderRotations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenRectangle3f getRenderShape(BlockState blockState) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.TEST.get(this.getSkin()));
        if (bakedSkin == null) {
            return null;
        }
        float f = 0.0625f;
        OpenRectangle3f box = bakedSkin.renderBounds().copy();
        box.mul(OpenMatrix4f.createScaleMatrix(-f, -f, f));
        return box;
    }

    private SimpleContainer getOrCreateItems() {
        if (this.container == null) {
            this.container = new SimpleContainer(this.getContainerSize());
        }
        return this.container;
    }

    public <V> Optional<V> getValueFromParent(Function<SkinnableBlockEntity, V> getter) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            return Optional.ofNullable(getter.apply(blockEntity));
        }
        return Optional.empty();
    }

    public <V> Optional<V> getLinkedValueFromParent(BiFunction<Level, BlockPos, V> getter) {
        GlobalPos globalPos = this.getLinkedPos();
        if (globalPos == null) {
            return Optional.empty();
        }
        Level level = this.getLevel();
        if (level == null) {
            return Optional.empty();
        }
        if (!Objects.equals(level.dimension(), globalPos.dimension())) {
            MinecraftServer server = level.getServer();
            if (server == null) {
                return Optional.empty();
            }
            level = server.getLevel(globalPos.dimension());
        }
        if (level == null || !level.isLoaded(globalPos.pos()) || this.callDepth > 10) {
            return Optional.empty();
        }
        ++this.callDepth;
        V result = getter.apply(level, globalPos.pos());
        --this.callDepth;
        return Optional.ofNullable(result);
    }

    private <V> V getProperty(SkinProperty<V> property) {
        SkinProperties properties = this.getProperties();
        if (properties != null) {
            return properties.get(property);
        }
        return property.defaultValue();
    }

    private LinkedSnapshot makeLinkedSnapshot() {
        Optional<LinkedSnapshot> result = this.getLinkedValueFromParent((level, pos) -> {
            LinkedSnapshot snapshot = new LinkedSnapshot();
            BlockState state = level.getBlockState(pos);
            if (state.hasAnalogOutputSignal()) {
                snapshot.analogOutputSignal = state.getAnalogOutputSignal(level, pos);
            }
            for (Direction dir : Direction.values()) {
                snapshot.redstoneSignal[dir.get3DDataValue()] = state.getSignal((BlockGetter)level, pos, dir);
                snapshot.directRedstoneSignal[dir.get3DDataValue()] = state.getDirectSignal((BlockGetter)level, pos, dir);
            }
            return snapshot;
        });
        return result.orElse(null);
    }

    private VoxelShape calcCollisionShape() {
        if (this.collisionShape.equals(OpenRectangle3i.ZERO)) {
            return Shapes.block();
        }
        float minX = (float)this.collisionShape.minX() / 16.0f + 0.5f;
        float minY = (float)this.collisionShape.minY() / 16.0f + 0.5f;
        float minZ = (float)this.collisionShape.minZ() / 16.0f + 0.5f;
        float maxX = (float)this.collisionShape.maxX() / 16.0f + 0.5f;
        float maxY = (float)this.collisionShape.maxY() / 16.0f + 0.5f;
        float maxZ = (float)this.collisionShape.maxZ() / 16.0f + 0.5f;
        return Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFERENCE = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, BlockPos.ZERO);
        public static final IDataSerializerKey<OpenRectangle3i> SHAPE = IDataSerializerKey.create("Shape", OpenRectangle3i.CODEC, OpenRectangle3i.ZERO);
        public static final IDataSerializerKey<GlobalPos> LINKED_POS = IDataSerializerKey.create("LinkedPos", IDataCodec.GLOBAL_POS, null);
        public static final IDataSerializerKey<SkinDescriptor> SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, SkinDescriptor.EMPTY);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<List<BlockPos>> REFERENCES = IDataSerializerKey.create("Refers", IDataCodec.BLOCK_POS.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<List<SkinMarker>> MARKERS = IDataSerializerKey.create("Markers", SkinMarker.CODEC.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }

    private static class LinkedSnapshot {
        private int analogOutputSignal = 0;
        private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
        private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};

        private LinkedSnapshot() {
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkedSnapshot)) {
                return false;
            }
            LinkedSnapshot snapshot = (LinkedSnapshot)o;
            return this.analogOutputSignal == snapshot.analogOutputSignal && Arrays.equals(this.redstoneSignal, snapshot.redstoneSignal) && Arrays.equals(this.directRedstoneSignal, snapshot.directRedstoneSignal);
        }

        public int hashCode() {
            int result = this.analogOutputSignal;
            result = 31 * result + Arrays.hashCode(this.redstoneSignal);
            result = 31 * result + Arrays.hashCode(this.directRedstoneSignal);
            return result;
        }
    }
}

