/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.api.common.ILootContext;
import moe.plushie.armourers_workshop.api.common.ILootContextParam;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.core.block.AbstractAttachedHorizontalBlock;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlock
extends AbstractAttachedHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockHandler {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;

    public SkinnableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)BedPart.HEAD)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKINNABLE.get()).create(level, blockPos, blockState);
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        SkinBlockPlaceContext context = SkinBlockPlaceContext.of(blockPos);
        if (context == null) {
            return;
        }
        context.parts().forEach(part -> {
            BlockPos target = blockPos.offset((Vec3i)part.offset());
            level.setBlock(target, blockState, 11);
            SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, target);
            if (blockEntity != null) {
                TagSerializer serializer = new TagSerializer(new CompoundTag(), level);
                part.serialize(serializer);
                blockEntity.readAdditionalData(serializer);
                blockEntity.updateBlockStates();
            }
        });
        super.setPlacedBy(level, blockPos, blockState, entity, itemStack);
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.is(blockState2.getBlock())) {
            this.brokenByAnything(level, blockPos, blockState, null);
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    public List<ItemStack> getDrops(BlockState blockState, ILootContext context) {
        SkinnableBlockEntity blockEntity1;
        List<ItemStack> results;
        block4: {
            block3: {
                results = super.getDrops(blockState, context);
                BlockEntity blockEntity = context.getOptionalParameter(ILootContextParam.BLOCK_ENTITY);
                if (!(blockEntity instanceof SkinnableBlockEntity)) break block3;
                blockEntity1 = (SkinnableBlockEntity)blockEntity;
                if (!results.isEmpty()) break block4;
            }
            return results;
        }
        ArrayList<ItemStack> fixedResults = new ArrayList<ItemStack>(results.size());
        for (ItemStack itemStack : results) {
            if (itemStack.is((Item)ModItems.SKIN.get()) && SkinDescriptor.of(itemStack).isEmpty() && (itemStack = blockEntity1.getDropped()) == null) continue;
            fixedResults.add(itemStack);
        }
        return fixedResults;
    }

    @Override
    public BlockState destroyByPlayer(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        this.brokenByAnything(level, blockPos, blockState, player);
        return super.destroyByPlayer(level, blockPos, blockState, player);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity == null) {
            return InteractionResult.FAIL;
        }
        if (blockEntity.isLinked()) {
            Optional<InteractionResult> result = blockEntity.getLinkedValueFromParent((level1, pos) -> {
                BlockState state = level1.getBlockState(pos);
                return super.useWithoutItem(state, (Level)level1, (BlockPos)pos, player, blockHitResult);
            });
            return result.orElse(InteractionResult.FAIL);
        }
        if (blockEntity.isBed() && !player.isSecondaryUseActive() && ModPermissions.SKINNABLE_SLEEP.accept(blockEntity, player)) {
            BlockState bedState = (BlockState)Blocks.RED_BED.defaultBlockState().setValue(PART, (Comparable)BedPart.HEAD);
            return super.useWithoutItem(bedState, level, blockEntity.getBedPos(), player, blockHitResult);
        }
        if (blockEntity.isSeat() && !player.isSecondaryUseActive() && ModPermissions.SKINNABLE_SIT.accept(blockEntity, player)) {
            if (level.isClientSide()) {
                return InteractionResult.CONSUME;
            }
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            SeatEntity seatEntity = this.getSeatEntity((ServerLevel)level, blockEntity.getParentPos(), seatPos);
            if (seatEntity == null) {
                return InteractionResult.FAIL;
            }
            player.startRiding((Entity)seatEntity, true);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity.isInventory()) {
            InteractionResult result = ((IMenuType)ModMenuTypes.SKINNABLE.get()).openMenu(player, level.getBlockEntity(blockPos));
            if (result.consumesAction()) {
                player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_CHEST));
            }
            return result;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        SkinBlockPlaceContext context1;
        BlockState state = super.getStateForPlacement(context);
        if (state != null && context instanceof SkinBlockPlaceContext && (context1 = (SkinBlockPlaceContext)context).getProperty(SkinProperty.BLOCK_GLOWING).booleanValue()) {
            state = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSkin().asItemStack();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isCustomBed(BlockGetter level, BlockPos blockPos, BlockState blockState, @Nullable Entity player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isBed();
        }
        return false;
    }

    @Override
    public boolean isCustomLadder(BlockGetter level, BlockPos blockPos, BlockState blockState, LivingEntity entity) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.isLadder();
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FACE, LIT, PART, OCCUPIED});
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getAnalogOutputSignal();
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos blockPos, Direction direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getSignal(direction);
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos blockPos, Direction direction) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getDirectSignal(direction);
        }
        return 0;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(blockGetter, blockPos);
        if (blockEntity != null) {
            return blockEntity.getCollisionShape();
        }
        return Shapes.empty();
    }

    public void forEach(Level level, BlockPos pos, Consumer<BlockPos> consumer) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return;
        }
        BlockPos parentPos = blockEntity.getBlockPos();
        for (BlockPos offset : blockEntity.getRefers()) {
            BlockPos targetPos = parentPos.offset((Vec3i)offset);
            if (targetPos.equals((Object)pos)) continue;
            consumer.accept(targetPos);
        }
    }

    public void brokenByAnything(Level level, BlockPos blockPos, BlockState blockState, @Nullable Player player) {
        if (this.dropItems(level, blockPos, player)) {
            this.killSeatEntities(level, blockPos);
            this.forEach(level, blockPos, target -> level.setBlock(target, Blocks.AIR.defaultBlockState(), 35));
        }
    }

    public void killSeatEntities(Level level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getParentBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity != null) {
            OpenVector3d seatPos = blockEntity.getSeatPos().add(0.5, 0.5, 0.5);
            this.killSeatEntity(level, blockEntity.getParentPos(), seatPos);
        }
    }

    public boolean dropItems(Level level, BlockPos blockPos, @Nullable Player player) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity((BlockGetter)level, blockPos);
        SkinnableBlockEntity parentBlockEntity = this.getParentBlockEntity((BlockGetter)level, blockPos);
        if (blockEntity == null || parentBlockEntity == null || parentBlockEntity.isDropped()) {
            return false;
        }
        ItemStack droppedStack = parentBlockEntity.getSkin().asItemStack();
        blockEntity.setDropped(droppedStack);
        parentBlockEntity.setDropped(droppedStack);
        if (parentBlockEntity.isInventory()) {
            DataSerializers.dropContents(level, blockPos, (Container)parentBlockEntity);
        }
        return true;
    }

    private SkinnableBlockEntity getBlockEntity(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            SkinnableBlockEntity blockEntity1 = (SkinnableBlockEntity)blockEntity;
            return blockEntity1;
        }
        return null;
    }

    private SkinnableBlockEntity getParentBlockEntity(BlockGetter level, BlockPos blockPos) {
        SkinnableBlockEntity blockEntity = this.getBlockEntity(level, blockPos);
        if (blockEntity != null) {
            return blockEntity.getParent();
        }
        return null;
    }

    @Nullable
    private SeatEntity getSeatEntity(ServerLevel level, BlockPos blockPos, OpenVector3d pos) {
        AABB searchRect = new AABB(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.getEntitiesOfClass(SeatEntity.class, searchRect)) {
            if (!entity.isAlive() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            if (entity.getPassengers().isEmpty()) {
                return entity;
            }
            return null;
        }
        SeatEntity entity = (SeatEntity)((IEntityType)ModEntityTypes.SEAT.get()).create(level, BlockPos.ZERO, null, MobSpawnType.SPAWN_EGG);
        entity.setPos(pos.x(), pos.y(), pos.z());
        entity.setBlockPos(blockPos);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    private void killSeatEntity(Level level, BlockPos blockPos, OpenVector3d pos) {
        AABB searchRect = new AABB(pos.x(), pos.y(), pos.z(), pos.x() + 1.0, pos.y() + 1.0, pos.z() + 1.0);
        for (SeatEntity entity : level.getEntitiesOfClass(SeatEntity.class, searchRect)) {
            if (!entity.isAlive() || !blockPos.equals((Object)entity.getBlockPos())) continue;
            entity.kill();
        }
    }
}

