/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeEventBus;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class AbstractForgeNetwork {

    public static class Proxy
    implements CustomPacketPayload {
        public static CustomPacketPayload.Type<Proxy> TYPE;
        public static StreamCodec<RegistryFriendlyByteBuf, Proxy> CODEC;
        public final IFriendlyByteBuf payload;

        public Proxy(IFriendlyByteBuf buffer) {
            this.payload = buffer;
        }

        public CustomPacketPayload.Type<Proxy> type() {
            return TYPE;
        }

        static {
            CODEC = new StreamCodec<RegistryFriendlyByteBuf, Proxy>(){

                public Proxy decode(RegistryFriendlyByteBuf bufferIn) {
                    ByteBuf buffer = bufferIn.retainedSlice();
                    RegistryFriendlyByteBuf duplicated = new RegistryFriendlyByteBuf(buffer, bufferIn.registryAccess());
                    bufferIn.skipBytes(bufferIn.readableBytes());
                    return new Proxy(IFriendlyByteBuf.wrap((ByteBuf)duplicated));
                }

                public void encode(RegistryFriendlyByteBuf buf, Proxy proxy) {
                    ByteBuf sending = proxy.payload.asByteBuf();
                    buf.writeBytes(sending.slice());
                }
            };
        }
    }

    public static class Distributors
    implements NetworkManager.Distributors {
        @Override
        public IPacketDistributor trackingChunk(Supplier<LevelChunk> supplier) {
            return new Distributor(LogicalSide.SERVER, msg -> PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)((LevelChunk)supplier.get()).getLevel()), (ChunkPos)((LevelChunk)supplier.get()).getPos(), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
        }

        @Override
        public IPacketDistributor trackingEntityAndSelf(Supplier<Entity> supplier) {
            return new Distributor(LogicalSide.SERVER, msg -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)supplier.get()), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
        }

        @Override
        public IPacketDistributor player(Supplier<ServerPlayer> supplier) {
            return new Distributor(LogicalSide.SERVER, msg -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)supplier.get()), (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
        }

        @Override
        public IPacketDistributor allPlayers() {
            return new Distributor(LogicalSide.SERVER, msg -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
        }

        @Override
        public IPacketDistributor server() {
            return new Distributor(LogicalSide.CLIENT, msg -> PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]), null);
        }
    }

    public static class Distributor
    implements IPacketDistributor {
        private final LogicalSide sender;
        private final Consumer<CustomPacketPayload> target;
        private final CustomPacketPayload packet;

        Distributor(LogicalSide sender, Consumer<CustomPacketPayload> target, CustomPacketPayload packet) {
            this.sender = sender;
            this.target = target;
            this.packet = packet;
        }

        @Override
        public IPacketDistributor add(IResourceLocation channel, IFriendlyByteBuf buf) {
            return new Distributor(this.sender, this.target, new Proxy(buf));
        }

        @Override
        public void execute() {
            if (this.packet == null) {
                return;
            }
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(this.sender);
            executor.submitAsync(() -> this.target.accept(this.packet));
        }

        @Override
        public boolean isClientbound() {
            return this.sender.isServer();
        }
    }

    public static class Dispatcher
    extends NetworkManager.Dispatcher {
        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            super(channelName, channelVersion);
        }

        @Override
        public void register() {
            AbstractForgeEventBus.observer(RegisterPayloadHandlersEvent.class, event -> {
                PayloadRegistrar registrar = event.registrar("armourers_workshop").versioned(this.channelVersion);
                Proxy.TYPE = new CustomPacketPayload.Type(this.channelName.toLocation());
                registrar.playBidirectional(Proxy.TYPE, Proxy.CODEC, this::handBidirectionalData);
            });
        }

        public void handBidirectionalData(Proxy proxy, IPayloadContext context) {
            if (context.flow().isServerbound()) {
                this.handleServerboundData(proxy, context);
            } else {
                this.handleClientboundData(proxy, context);
            }
        }

        public void handleServerboundData(Proxy proxy, IPayloadContext context) {
            ServerPlayer player = (ServerPlayer)context.player();
            IServerPacketHandler packetHandler = arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0);
            this.didReceivePacket(packetHandler, proxy.payload.slice(), player);
        }

        public void handleClientboundData(Proxy proxy, IPayloadContext context) {
            IClientPacketHandler packetHandler = arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0);
            this.didReceivePacket(packetHandler, proxy.payload.slice(), null);
        }
    }
}

