/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.core.client.other.SmartResourceManager;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class AbstractPackResources
implements PackResources {
    private final PackLocationInfo location;
    private final SmartResourceManager resourceManager;
    private final PackType packType;

    public AbstractPackResources(SmartResourceManager resourceManager, PackType packType) {
        this.location = new PackLocationInfo(resourceManager.id(), (Component)Component.empty(), PackSource.DEFAULT, Optional.empty());
        this.resourceManager = resourceManager;
        this.packType = packType;
    }

    public static boolean isModResources(PackResources resources) {
        return !resources.packId().startsWith("file/");
    }

    public Set<String> getNamespaces(PackType packType) {
        return this.resourceManager.getNamespaces(packType);
    }

    @Nullable
    public final IoSupplier<InputStream> getRootResource(String ... strings) {
        return null;
    }

    @Nullable
    public final IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        Supplier<InputStream> supplier = this.resourceManager.getResource(packType, OpenResourceLocation.create(location));
        if (supplier != null) {
            return supplier::get;
        }
        return null;
    }

    @Nullable
    public final <T> T getMetadataSection(MetadataSectionSerializer<T> metadataSectionSerializer) throws IOException {
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
    }

    public final PackLocationInfo location() {
        return this.location;
    }

    public void close() {
    }
}

