/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFriendlyByteBufImpl
implements IFriendlyByteBuf {
    protected final RegistryFriendlyByteBuf source;

    protected AbstractFriendlyByteBufImpl(RegistryFriendlyByteBuf source) {
        this.source = source;
    }

    protected static RegistryFriendlyByteBuf cast(ByteBuf buf) {
        if (buf instanceof RegistryFriendlyByteBuf) {
            RegistryFriendlyByteBuf source = (RegistryFriendlyByteBuf)buf;
            return source;
        }
        return new RegistryFriendlyByteBuf(buf, AbstractFriendlyByteBufImpl.findRegistryAccess());
    }

    protected static RegistryFriendlyByteBuf map(ByteBuf buf, Function<ByteBuf, ByteBuf> transform) {
        if (buf instanceof RegistryFriendlyByteBuf) {
            RegistryFriendlyByteBuf source = (RegistryFriendlyByteBuf)buf;
            return new RegistryFriendlyByteBuf(transform.apply(buf), source.registryAccess());
        }
        return new RegistryFriendlyByteBuf(transform.apply(buf), AbstractFriendlyByteBufImpl.findRegistryAccess());
    }

    protected static RegistryAccess findRegistryAccess() {
        MinecraftServer server = EnvironmentManager.getServer();
        if (server != null) {
            return server.registryAccess();
        }
        Optional<Object> client = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> {
            ClientPacketListener connection = EnvironmentManager.getClient().getConnection();
            if (connection != null) {
                return connection.registryAccess();
            }
            return null;
        });
        return client.orElse(null);
    }

    @Override
    public GlobalPos readGlobalPos() {
        return this.source.readGlobalPos();
    }

    @Override
    public void writeGlobalPos(GlobalPos value) {
        this.source.writeGlobalPos(value);
    }

    @Override
    public ItemStack readItem() {
        return (ItemStack)ItemStack.STREAM_CODEC.decode((Object)this.source);
    }

    @Override
    public void writeItem(ItemStack value) {
        ItemStack.STREAM_CODEC.encode((Object)this.source, (Object)value);
    }

    @Override
    public Component readComponent() {
        return (Component)ComponentSerialization.STREAM_CODEC.decode((Object)this.source);
    }

    @Override
    public void writeComponent(Component value) {
        ComponentSerialization.STREAM_CODEC.encode((Object)this.source, (Object)value);
    }

    @Override
    public <T> T readNbtWithCodec(IDataCodec<T> codec) {
        DataResult dataResult = codec.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)this.readNbt());
        return (T)dataResult.getOrThrow(string -> new DecoderException("Failed to decode json: " + string));
    }

    @Override
    public <T> void writeNbtWithCodec(IDataCodec<T> codec, T value) {
        DataResult dataResult = codec.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, value);
        this.writeNbt((CompoundTag)dataResult.getOrThrow(string -> new EncoderException("Failed to encode: " + string + " " + String.valueOf(value))));
    }
}

