/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.HashMap;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class AbstractDataComponentization {
    public static void init(DataFixerBuilder builder, Schema schema) {
        builder.addFixer((DataFix)new SkinWardrobeFix(schema));
        builder.addFixer((DataFix)new MannequinEntityFix(schema));
        builder.addFixer((DataFix)new BlockEntityFixer(schema));
    }

    private static Dynamic<?> updateItem(Dynamic<?> item) {
        DataFixer dataFixer = DataFixers.getDataFixer();
        return dataFixer.update(References.ITEM_STACK, item, 3816, 3820);
    }

    private static Dynamic<?> updateItemList(Dynamic<?> list) {
        return list.createList(list.asStream().map(AbstractDataComponentization::updateItem));
    }

    public static class SkinWardrobeFix
    extends DataFix {
        public SkinWardrobeFix(Schema schema) {
            super(schema, false);
        }

        protected TypeRewriteRule makeRule() {
            Schema schema = this.getInputSchema();
            return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("(AW) SkinWardrobeFix", schema.getType(References.ENTITY), typed -> typed.update(DSL.remainderFinder(), this::fix)), (TypeRewriteRule)this.fixTypeEverywhereTyped("(AW) SkinWardrobeFix", schema.getType(References.PLAYER), typed -> typed.update(DSL.remainderFinder(), this::fix)));
        }

        private Dynamic<?> fix(Dynamic<?> entityTag) {
            String registryName = "armourers_workshop:entity-skin-provider";
            Dynamic oldWardrobe = entityTag.get("ForgeCaps").get(registryName).result().orElse(null);
            if (oldWardrobe == null) {
                return entityTag;
            }
            Dynamic newWardrobe = oldWardrobe.update("Items", AbstractDataComponentization::updateItemList);
            Dynamic attachments = entityTag.get("neoforge:attachments").result().orElse(null);
            if (attachments == null) {
                attachments = entityTag.createMap(new HashMap());
            }
            return entityTag.update("ForgeCaps", caps -> caps.remove(registryName)).set("neoforge:attachments", attachments.set(registryName, newWardrobe));
        }
    }

    public static class MannequinEntityFix
    extends NamedEntityFix {
        public MannequinEntityFix(Schema schema) {
            super(schema, false, "(AW) MannequinEntityFix", References.ENTITY, "armourers_workshop:mannequin");
        }

        protected Typed<?> fix(Typed<?> typed) {
            return typed.update(DSL.remainderFinder(), data -> data.update("HandItems", AbstractDataComponentization::updateItemList).update("ArmorItems", AbstractDataComponentization::updateItemList));
        }
    }

    public static class BlockEntityFixer
    extends DataFix {
        public BlockEntityFixer(Schema schema) {
            super(schema, false);
        }

        protected TypeRewriteRule makeRule() {
            Schema inputSchema = this.getInputSchema();
            return this.fixTypeEverywhereTyped("(AW) BlockEntityFix", inputSchema.getType(References.BLOCK_ENTITY), typed -> typed.update(DSL.remainderFinder(), this::fix));
        }

        protected Dynamic<?> fix(Dynamic<?> entityTag) {
            String id = entityTag.get("id").asString().result().orElse(null);
            if (id == null || !id.startsWith("armourers_workshop:")) {
                return entityTag;
            }
            return entityTag.update("Items", AbstractDataComponentization::updateItemList);
        }
    }
}

