/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.serialization.Codec;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.Nullable;

public class AbstractDataComponentType<T>
implements DataComponentType<T>,
IDataComponentType<T> {
    protected final DataComponentType<T> key;
    protected final String tag;
    protected final IDataCodec<T> codec;
    protected final StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec;

    public AbstractDataComponentType(String tag, IDataCodec<T> codec) {
        this.tag = tag;
        this.codec = codec;
        this.streamCodec = ByteBufCodecs.fromCodecWithRegistries(codec.codec());
        this.key = this;
    }

    public static <T> AbstractDataComponentType<T> create(String tag, IDataCodec<T> codec) {
        if (tag.equals("EntityTag")) {
            return new Proxy<T>((DataComponentType<CustomData>)DataComponents.ENTITY_DATA, tag, codec);
        }
        if (tag.equals("BlockEntityTag")) {
            return new Proxy<T>((DataComponentType<CustomData>)DataComponents.BLOCK_ENTITY_DATA, tag, codec);
        }
        return new AbstractDataComponentType<T>(tag, codec);
    }

    public boolean isProxy() {
        return this instanceof Proxy;
    }

    @Override
    public boolean has(ItemStack itemStack) {
        return itemStack.has(this.key);
    }

    @Override
    public void set(ItemStack itemStack, @Nullable T value) {
        itemStack.set(this.key, value);
    }

    @Override
    @Nullable
    public T get(ItemStack itemStack) {
        return (T)itemStack.get(this.key);
    }

    @Override
    public T getOrDefault(ItemStack itemStack, T defaultValue) {
        return (T)itemStack.getOrDefault(this.key, defaultValue);
    }

    @Override
    public void remove(ItemStack itemStack) {
        itemStack.remove(this.key);
    }

    @Nullable
    public Codec<T> codec() {
        return this.codec.codec();
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public static class Proxy<T>
    extends AbstractDataComponentType<T> {
        protected final DataComponentType<CustomData> target;

        public Proxy(DataComponentType<CustomData> target, String tag, IDataCodec<T> codec) {
            super(tag, codec);
            this.target = target;
        }

        @Override
        public boolean has(ItemStack itemStack) {
            return itemStack.has(this.target);
        }

        @Override
        public void set(ItemStack itemStack, @Nullable T value) {
            if (value != null) {
                itemStack.set(this.target, (Object)CustomData.of((CompoundTag)this.encode(value)));
            } else {
                itemStack.set(this.target, null);
            }
        }

        @Override
        @Nullable
        public T get(ItemStack itemStack) {
            CustomData customData = (CustomData)itemStack.get(this.target);
            if (customData != null) {
                return this.decode(customData.getUnsafe());
            }
            return null;
        }

        @Override
        public T getOrDefault(ItemStack itemStack, T defaultValue) {
            CustomData customData = (CustomData)itemStack.get(this.target);
            if (customData != null) {
                return this.decode(customData.getUnsafe());
            }
            return defaultValue;
        }

        @Override
        public void remove(ItemStack itemStack) {
            itemStack.remove(this.target);
        }

        private CompoundTag encode(T value) {
            return (CompoundTag)Objects.unsafeCast(value);
        }

        private T decode(CompoundTag tag) {
            return Objects.unsafeCast(tag);
        }
    }
}

