/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AbstractRegistryResolver {
    private static final Map<String, Optional<TagKey<Item>>> NAMED_ITEM_TAGS = new ConcurrentHashMap<String, Optional<TagKey<Item>>>();
    private static final Map<String, Optional<TagKey<Block>>> NAMED_BLOCK_TAGS = new ConcurrentHashMap<String, Optional<TagKey<Block>>>();
    private static final Map<String, Optional<TagKey<Biome>>> NAMED_BIOME_TAGS = new ConcurrentHashMap<String, Optional<TagKey<Biome>>>();
    private static final Map<String, Optional<? extends Holder<Attribute>>> NAMED_ATTRIBUTES = new ConcurrentHashMap<String, Optional<? extends Holder<Attribute>>>();
    private static final Map<String, Optional<? extends Holder<MobEffect>>> NAMED_EFFECTS = new ConcurrentHashMap<String, Optional<? extends Holder<MobEffect>>>();
    private static final Map<String, Optional<? extends Holder<Enchantment>>> NAMED_ENCHANTMENTS = new ConcurrentHashMap<String, Optional<? extends Holder<Enchantment>>>();

    public static String getItemKey(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static String getBlockKey(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
    }

    public static boolean hasItemTag(ItemStack itemStack, String tagName) {
        Optional tag = NAMED_ITEM_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, Registries.ITEM));
        return tag.map(arg_0 -> ((ItemStack)itemStack).is(arg_0)).orElse(false);
    }

    public static boolean hasBlockTag(BlockState blockState, String tagName) {
        Optional tag = NAMED_BLOCK_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, Registries.BLOCK));
        return tag.map(arg_0 -> ((BlockState)blockState).is(arg_0)).orElse(false);
    }

    public static boolean hasBiomeTag(Object biome, String tagName) {
        Holder biome1 = (Holder)Objects.unsafeCast(biome);
        Optional tag = NAMED_BIOME_TAGS.computeIfAbsent(tagName, it -> AbstractRegistryResolver.findTag(it, Registries.BIOME));
        return tag.map(arg_0 -> ((Holder)biome1).is(arg_0)).orElse(false);
    }

    @Nullable
    public static Object getBiome(Level level, BlockPos blockPos) {
        return level.getBiome(blockPos);
    }

    @Nullable
    public static MobEffectInstance getEffect(LivingEntity entity, String effectName) {
        Optional value = NAMED_EFFECTS.computeIfAbsent(effectName, it -> AbstractRegistryResolver.findValue(it, Registries.MOB_EFFECT));
        return value.map(arg_0 -> ((LivingEntity)entity).getEffect(arg_0)).orElse(null);
    }

    public static double getAttribute(LivingEntity entity, String attributeName) {
        Optional value = NAMED_ATTRIBUTES.computeIfAbsent(attributeName, it -> AbstractRegistryResolver.findValue(it, Registries.ATTRIBUTE));
        return value.map(arg_0 -> ((LivingEntity)entity).getAttributeValue(arg_0)).orElse(0.0);
    }

    public static Object getEnchantment(ItemStack itemStack, String enchantmentName) {
        Optional value = NAMED_ENCHANTMENTS.computeIfAbsent(enchantmentName, it -> AbstractRegistryResolver.findValue(it, Registries.ENCHANTMENT));
        return value.map(it -> EnchantmentHelper.getItemEnchantmentLevel((Holder)it, (ItemStack)itemStack)).orElse(null);
    }

    private static <T> Optional<TagKey<T>> findTag(String name, ResourceKey<? extends Registry<T>> resourceKey) {
        ResourceLocation key = ResourceLocation.tryParse((String)name);
        if (key != null) {
            return Optional.of(TagKey.create(resourceKey, (ResourceLocation)key));
        }
        return Optional.empty();
    }

    private static <T> Optional<? extends Holder<T>> findValue(String name, ResourceKey<? extends Registry<T>> resourceKey) {
        ResourceLocation key = ResourceLocation.tryParse((String)name);
        if (key == null) {
            return Optional.empty();
        }
        RegistryAccess registryAccess = AbstractRegistryResolver.findRegistryAccess();
        if (registryAccess == null) {
            return Optional.empty();
        }
        Registry registry = registryAccess.registry(resourceKey).orElse(null);
        if (registry == null) {
            return Optional.empty();
        }
        return registry.getHolder(key);
    }

    protected static RegistryAccess findRegistryAccess() {
        MinecraftServer server = EnvironmentManager.getServer();
        if (server != null) {
            return server.registryAccess();
        }
        Optional<Object> client = EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> {
            ClientPacketListener connection = EnvironmentManager.getClient().getConnection();
            if (connection != null) {
                return connection.registryAccess();
            }
            return null;
        });
        return client.orElse(null);
    }
}

