/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AbstractLootItemFunctionType<T extends ILootFunction>
implements ILootFunctionType<T> {
    private final LootItemFunctionType<?> type;

    public AbstractLootItemFunctionType(LootItemFunctionType<?> type) {
        this.type = type;
    }

    public static <T extends ILootFunction> AbstractLootItemFunctionType<T> conditional(MapCodec<T> codec) {
        LootItemFunctionType[] type = new LootItemFunctionType[]{null};
        type[0] = new LootItemFunctionType(ConditionalFunction.createCodec(() -> (LootItemFunctionType)Objects.unsafeCast(type[0]), codec));
        return new AbstractLootItemFunctionType<T>(type[0]);
    }

    public LootItemFunctionType<?> getType() {
        return this.type;
    }

    public static class ConditionalFunction<T extends ILootFunction>
    extends LootItemConditionalFunction {
        private final T value;
        private final Supplier<LootItemFunctionType<? extends LootItemConditionalFunction>> type;

        protected ConditionalFunction(List<LootItemCondition> args, T value, Supplier<LootItemFunctionType<? extends LootItemConditionalFunction>> type) {
            super(args);
            this.type = type;
            this.value = value;
        }

        public static <T extends ILootFunction> MapCodec<? extends ConditionalFunction<T>> createCodec(Supplier<LootItemFunctionType<? extends LootItemConditionalFunction>> type, MapCodec<T> codec) {
            return RecordCodecBuilder.mapCodec(instance -> ConditionalFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)codec.forGetter(ConditionalFunction::getValue)).apply((Applicative)instance, (arg_0, arg_1) -> ConditionalFunction.lambda$createCodec$0((Supplier)type, arg_0, arg_1)));
        }

        protected ItemStack run(ItemStack arg, LootContext arg2) {
            return this.value.apply(arg, arg2);
        }

        public void validate(ValidationContext arg) {
            this.value.validate(arg);
        }

        public Set<LootContextParam<?>> getReferencedContextParams() {
            return this.value.getReferencedContextParams();
        }

        public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
            return this.type.get();
        }

        public T getValue() {
            return this.value;
        }

        private static /* synthetic */ ConditionalFunction lambda$createCodec$0(Supplier type, List args, ILootFunction value) {
            return new ConditionalFunction<ILootFunction>(args, value, type);
        }
    }
}

