/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import net.minecraft.client.DeltaTracker;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AbstractDeltaTracker {
    private final Level level;
    private final DeltaTracker delta;
    private final boolean isPaused;

    public AbstractDeltaTracker(Level level, DeltaTracker delta, boolean isPaused) {
        this.level = level;
        this.delta = delta;
        this.isPaused = isPaused;
    }

    public float getPartialTick() {
        return this.delta.getGameTimeDeltaPartialTick(true);
    }

    public float getPartialTick(Entity entity) {
        TickRateManager tickRateManager = this.getTickRateManager();
        if (tickRateManager == null) {
            return this.getPartialTick();
        }
        boolean flag = tickRateManager.isEntityFrozen(entity);
        return this.delta.getGameTimeDeltaPartialTick(flag);
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isFrozen() {
        TickRateManager tickRateManager = this.getTickRateManager();
        return tickRateManager != null && !tickRateManager.runsNormally();
    }

    public TickRateManager getTickRateManager() {
        if (this.level != null) {
            return this.level.tickRateManager();
        }
        return null;
    }
}

