/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.impl.EntityRendererImpl;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractGraphicsRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRendererImpl {
    private static final EntityRendererImpl<LivingEntity> DEFAULT_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        int tx = (int)origin.x;
        int ty = (int)origin.y;
        float s = entity.getScale();
        float f = -entity.getBbHeight() / 2.0f / s;
        GuiGraphics guiGraphics = AbstractGraphicsRenderer.of(context);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 50.0f);
        poseStack.scale(s, s, s);
        poseStack.translate(0.0f, 0.0f, -50.0f);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)tx, (int)ty, (int)tx, (int)ty, (int)scale, (float)f, (float)focus.x(), (float)focus.y(), (LivingEntity)entity);
        poseStack.popPose();
    };
    private static final EntityRendererImpl<Entity> CUSTOM_ENTITY_RENDERER = (entity, origin, scale, focus, context) -> {
        float p = (float)Math.atan((0.0f - focus.x) / 40.0f);
        float q = (float)Math.atan((0.0f - focus.y) / 40.0f);
        OpenQuaternionf quaternion = OpenVector3f.ZP.rotationDegrees(180.0f);
        OpenQuaternionf quaternion2 = OpenVector3f.XP.rotationDegrees(q * 20.0f);
        quaternion.mul(OpenVector3f.YP.rotationDegrees(180.0f));
        quaternion.mul(quaternion2);
        float s = entity.getYRot();
        float t = entity.getXRot();
        entity.setYRot(p * 40.0f);
        entity.setXRot(-q * 20.0f);
        GuiGraphics guiGraphics = AbstractGraphicsRenderer.of(context);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)origin.x, (double)origin.y, 50.0);
        poseStack.mulPose(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        ABI.mulPose(poseStack, quaternion);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher renderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        quaternion2.conjugate();
        renderDispatcher.overrideCameraOrientation(AbstractPoseStack.copyQuaternion(quaternion2));
        renderDispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> renderDispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0));
        guiGraphics.flush();
        renderDispatcher.setRenderShadow(true);
        entity.setYRot(s);
        entity.setXRot(t);
        poseStack.popPose();
        Lighting.setupFor3DItems();
    };

    public static <T extends Entity> EntityRendererImpl<T> getRenderer(T entity) {
        if (entity instanceof LivingEntity) {
            return DEFAULT_ENTITY_RENDERER;
        }
        return CUSTOM_ENTITY_RENDERER;
    }
}

