/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.VertexFormat;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.VertexFormat.ABI;
import moe.plushie.armourers_workshop.utils.EnumMapper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractVertexFormat
implements IVertexFormat {
    private static final EnumMapper<IVertexFormat.Mode, VertexFormat.Mode> MAPPER = EnumMapper.create(IVertexFormat.Mode.LINES, VertexFormat.Mode.LINES, it -> {
        it.put(IVertexFormat.Mode.LINES, VertexFormat.Mode.LINES);
        it.put(IVertexFormat.Mode.LINE_STRIP, VertexFormat.Mode.LINE_STRIP);
        it.put(IVertexFormat.Mode.DEBUG_LINES, VertexFormat.Mode.DEBUG_LINES);
        it.put(IVertexFormat.Mode.DEBUG_LINE_STRIP, VertexFormat.Mode.DEBUG_LINE_STRIP);
        it.put(IVertexFormat.Mode.TRIANGLES, VertexFormat.Mode.TRIANGLES);
        it.put(IVertexFormat.Mode.TRIANGLE_STRIP, VertexFormat.Mode.TRIANGLE_STRIP);
        it.put(IVertexFormat.Mode.TRIANGLE_FAN, VertexFormat.Mode.TRIANGLE_FAN);
        it.put(IVertexFormat.Mode.QUADS, VertexFormat.Mode.QUADS);
    });
    private final VertexFormat impl;

    private AbstractVertexFormat(VertexFormat impl) {
        this.impl = impl;
    }

    public static IVertexFormat of(VertexFormat format) {
        return new AbstractVertexFormat(format);
    }

    public static IVertexFormat.Mode of(VertexFormat.Mode mode) {
        return MAPPER.getKey(mode);
    }

    @Override
    public void setupBufferState(long offset) {
        ABI.setupBufferState(this.impl, offset);
    }

    @Override
    public void clearBufferState() {
        this.impl.clearBufferState();
    }

    @Override
    public int vertexSize() {
        return this.impl.getVertexSize();
    }

    @Override
    public VertexFormat get() {
        return this.impl;
    }
}

