/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import java.nio.ByteBuffer;
import moe.plushie.armourers_workshop.api.client.IBufferBuilder;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderedBuffer;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractVertexFormat;
import net.minecraft.client.renderer.RenderType;

public class AbstractBufferBuilder
extends AbstractVertexConsumer
implements IBufferBuilder {
    private final ByteBufferBuilder buffers;
    private BufferBuilder bufferBuilder;

    public AbstractBufferBuilder(int size) {
        super(null);
        this.buffers = new ByteBufferBuilder(size);
    }

    public static void upload(IRenderType renderType, AbstractBufferBuilder builder) {
        RenderType renderType1 = (RenderType)renderType.get();
        MeshData meshData = builder.bufferBuilder.build();
        if (meshData != null) {
            renderType1.draw(meshData);
        }
    }

    @Override
    public void begin(IRenderType renderType) {
        RenderType renderType1 = (RenderType)renderType.get();
        BufferBuilder builder = new BufferBuilder(this.buffers, renderType1.mode(), renderType1.format());
        this.parent = builder;
        this.bufferBuilder = builder;
    }

    @Override
    public IRenderedBuffer end() {
        final MeshData meshData = this.bufferBuilder.buildOrThrow();
        final IVertexFormat format = AbstractVertexFormat.of(meshData.drawState().format());
        return new IRenderedBuffer(){

            @Override
            public IVertexFormat format() {
                return format;
            }

            @Override
            public ByteBuffer vertexBuffer() {
                return meshData.vertexBuffer();
            }

            @Override
            public int vertexCount() {
                return meshData.drawState().vertexCount();
            }

            @Override
            public void release() {
                meshData.close();
            }
        };
    }

    public BufferBuilder bufferBuilder() {
        return this.bufferBuilder;
    }
}

