/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import java.util.Objects;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class UpdateColorPickerPacket
extends CustomPacket {
    final InteractionHand hand;
    final ItemStack itemStack;

    public UpdateColorPickerPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(InteractionHand.class);
        this.itemStack = buffer.readItem();
    }

    public UpdateColorPickerPacket(InteractionHand hand, ItemStack itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeItem(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ItemStack holdItemStack = player.getItemInHand(this.hand);
        if (Objects.equals(holdItemStack.getItem(), this.itemStack.getItem())) {
            player.setItemInHand(this.hand, this.itemStack);
        }
    }
}

