/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.builder.other.WorldUtils;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ArmourerMenu
extends AbstractBlockEntityMenu<ArmourerBlockEntity> {
    private final SimpleContainer inventory = new SimpleContainer(4);
    private Group group = null;

    public ArmourerMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IGlobalPos access) {
        super((MenuType)menuType, block, containerId, access);
        this.addPlayerSlots((Container)playerInventory, 8, 142, this.visibleSlotBuilder(this::shouldRenderInventory));
        this.addCustomSlot((Container)this.inventory, 0, 64, 21);
        this.addCustomSlot((Container)this.inventory, 1, 147, 21);
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, (Container)this.inventory);
    }

    public boolean shouldLoadArmourItem(Player player) {
        ItemStack stackInput = this.inventory.getItem(0);
        ItemStack stackOutput = this.inventory.getItem(1);
        if (stackInput.isEmpty() || !stackOutput.isEmpty()) {
            return false;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        return !descriptor.isEmpty();
    }

    public boolean shouldSaveArmourItem(Player player) {
        ItemStack stackInput = this.inventory.getItem(0);
        ItemStack stackOutput = this.inventory.getItem(1);
        if (player.isCreative() && stackInput.isEmpty()) {
            stackInput = new ItemStack((ItemLike)ModItems.SKIN_TEMPLATE.get());
        }
        return !stackInput.isEmpty() && stackOutput.isEmpty();
    }

    public void saveArmourItem(Player player, GameProfile profile, String customName, String tags) {
        if (!this.shouldSaveArmourItem(player)) {
            return;
        }
        if (((ArmourerBlockEntity)this.blockEntity).getLevel() == null || ((ArmourerBlockEntity)this.blockEntity).getLevel().isClientSide()) {
            return;
        }
        try {
            ItemStack stackInput = this.inventory.getItem(0);
            SkinProperties skinProps = ((ArmourerBlockEntity)this.blockEntity).skinProperties().copy();
            skinProps.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                skinProps.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            if (customName != null) {
                skinProps.put(SkinProperty.ALL_CUSTOM_NAME, customName);
            }
            Level level = ((ArmourerBlockEntity)this.blockEntity).getLevel();
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            Skin skin = WorldUtils.saveSkinFromWorld(level, transform, skinProps, ((ArmourerBlockEntity)this.blockEntity).skinType(), ((ArmourerBlockEntity)this.blockEntity).paintData());
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
            if (!player.isCreative()) {
                stackInput.shrink(1);
            }
            this.inventory.setItem(1, descriptor.asItemStack());
        }
        catch (TranslatableException exception) {
            player.sendSystemMessage(exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadArmourItem(Player player) {
        if (((ArmourerBlockEntity)this.blockEntity).getLevel() == null || ((ArmourerBlockEntity)this.blockEntity).getLevel().isClientSide()) {
            return;
        }
        ItemStack stackInput = this.inventory.getItem(0);
        SkinDescriptor descriptor = SkinDescriptor.of(stackInput);
        if (!this.shouldLoadArmourItem(player)) {
            return;
        }
        try {
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.identifier());
            if (skin == null) {
                throw SkinLoadException.Type.NOT_FOUND.build("notFound", new Object[0]);
            }
            if (skin.type() != ((ArmourerBlockEntity)this.blockEntity).skinType()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_TYPE.build("notSupportType", new Object[0]);
            }
            if (!skin.isBasicOnly()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_CONTENT.build("notSupportContent", new Object[0]);
            }
            if (!skin.settings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            ((ArmourerBlockEntity)this.blockEntity).setSkinProperties(skin.properties());
            ((ArmourerBlockEntity)this.blockEntity).setPaintData(skin.paintData());
            CubeChangesCollector collector = new CubeChangesCollector(((ArmourerBlockEntity)this.blockEntity).getLevel());
            CubeTransform transform = ((ArmourerBlockEntity)this.blockEntity).transform();
            WorldUtils.loadSkinIntoWorld(collector, transform, skin);
            collector.submit((Component)Component.translatable((String)"action.armourers_workshop.block.load"), player);
            this.inventory.setItem(0, ItemStack.EMPTY);
            this.inventory.setItem(1, stackInput);
        }
        catch (TranslatableException exception) {
            player.sendSystemMessage(exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        return this.quickMoveStack(player, index, this.slots.size() - 1);
    }

    protected void addCustomSlot(Container inventory, final int slot, int x, int y) {
        this.addSlot(new GroupSlot(this, inventory, slot, x, y){

            public boolean mayPlace(ItemStack itemStack) {
                if (slot == 0) {
                    if (itemStack.is((Item)ModItems.SKIN_TEMPLATE.get())) {
                        return true;
                    }
                    return !SkinDescriptor.of(itemStack).isEmpty();
                }
                return false;
            }
        });
    }

    public Group group() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public boolean shouldRenderInventory() {
        return this.group == Group.MAIN;
    }

    public static enum Group {
        MAIN,
        SKIN,
        DISPLAY,
        BLOCK;

    }

    public class GroupSlot
    extends Slot {
        public GroupSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean isActive() {
            return ArmourerMenu.this.shouldRenderInventory();
        }
    }
}

