/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.entity;

import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.Options.FOVSupport;
import moe.plushie.armourers_workshop.core.entity.SeatEntity;
import moe.plushie.armourers_workshop.core.math.OpenNearPlane;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CameraEntity
extends SeatEntity {
    private float zoom = 0.0f;
    private CameraType cameraType;
    private final Minecraft minecraft = EnvironmentManager.getClient();

    public CameraEntity() {
        super((EntityType<? extends SeatEntity>)((EntityType)((IEntityType)ModEntityTypes.SEAT.get()).get()), (Level)EnvironmentManager.getClient().level);
    }

    public void connect() {
        this.cameraType = this.minecraft.options.getCameraType();
        this.minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        this.minecraft.setCameraEntity((Entity)this);
    }

    public void disconnect() {
        this.minecraft.setCameraEntity(null);
        this.minecraft.options.setCameraType(this.cameraType);
    }

    public float getViewXRot(float f) {
        return this.getXRot();
    }

    public float getViewYRot(float f) {
        return this.getYRot();
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getMaxZoom(float targetZoom) {
        return targetZoom * this.zoom;
    }

    public OpenNearPlane getNearPlane() {
        float rx = this.getXRot();
        float ry = this.getYRot();
        float width = this.minecraft.getWindow().getWidth();
        float height = this.minecraft.getWindow().getHeight();
        float fov = FOVSupport.getCameraFOV(this.minecraft.options);
        return new OpenNearPlane(rx, ry, width, height, fov);
    }
}

