/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.apple.library.uikit.UIColor;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintingHighlightPlacementRenderer {
    public static void renderPaintTool(ItemStack itemStack, Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        float z1;
        float y1;
        float x1;
        float z0;
        float y0;
        float x0;
        Level level = PropertyProvider.getLevel((Entity)player);
        BlockPos pos = traceResult.getBlockPos();
        OpenDirection direction = AbstractDirection.wrap(traceResult.getDirection());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IBlockPaintable)) {
            return;
        }
        Integer radiusSample = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_SAMPLE);
        Integer radiusEffect = ToolAPI.get(itemStack, PaintingToolOptions.RADIUS_EFFECT);
        Boolean restrictPlane = ToolAPI.get(itemStack, PaintingToolOptions.PLANE_RESTRICT);
        ArrayList<BlockPos> blockSamples = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusSample, restrictPlane);
        ArrayList<BlockPos> blockEffects = BlockUtils.findTouchingBlockFaces(level, pos, direction, radiusEffect, restrictPlane);
        poseStack.pushPose();
        Vec3 origin = renderInfo.getPosition();
        IVertexConsumer builder = bufferSource.getBuffer(SkinRenderType.HIGHLIGHTED_LINES);
        poseStack.translate((float)(-origin.x()), (float)(-origin.y()), (float)(-origin.z()));
        poseStack.translate(0.5f, 0.5f, 0.5f);
        for (BlockPos pos1 : blockSamples) {
            x0 = (float)pos1.getX() - 0.5f;
            y0 = (float)pos1.getY() - 0.5f;
            z0 = (float)pos1.getZ() - 0.5f;
            x1 = (float)pos1.getX() + 0.5f;
            y1 = (float)pos1.getY() + 0.5f;
            z1 = (float)pos1.getZ() + 0.5f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.RED, poseStack, builder);
        }
        for (BlockPos pos1 : blockEffects) {
            x0 = (float)pos1.getX() - 0.4f;
            y0 = (float)pos1.getY() - 0.4f;
            z0 = (float)pos1.getZ() - 0.4f;
            x1 = (float)pos1.getX() + 0.4f;
            y1 = (float)pos1.getY() + 0.4f;
            z1 = (float)pos1.getZ() + 0.4f;
            ShapeTesselator.fill(x0, y0, z0, x1, y1, z1, UIColor.GREEN, poseStack, builder);
        }
        poseStack.popPose();
    }
}

