/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer.guide;

import java.util.HashMap;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.AbstractGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.ChestGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.FeetGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.HeadGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.HeldItemGuideRenderer;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.WingsGuideRenderer;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class GuideRendererManager {
    private final HashMap<SkinPartType, GuideRenderer> renderers = new HashMap();
    private final HashMap<Pair<EntityTextureDescriptor.Model, SkinPartType>, GuideRenderer> variantRenderers = new HashMap();

    public GuideRendererManager() {
        this.register(new HeadGuideRenderer());
        this.register(new ChestGuideRenderer());
        this.register(new FeetGuideRenderer());
        this.register(new HeldItemGuideRenderer());
        this.register(new WingsGuideRenderer());
    }

    private void register(AbstractGuideRenderer renderer) {
        renderer.init(this);
    }

    public void register(SkinPartType partType, GuideRenderer renderer) {
        this.renderers.put(partType, renderer);
    }

    public void register(EntityTextureDescriptor.Model model, SkinPartType partType, GuideRenderer renderer) {
        this.variantRenderers.put((Pair<EntityTextureDescriptor.Model, SkinPartType>)Pair.of((Object)((Object)model), (Object)partType), renderer);
    }

    public GuideRenderer getRenderer(EntityTextureDescriptor.Model model, SkinPartType partType) {
        return this.variantRenderers.computeIfAbsent((Pair<EntityTextureDescriptor.Model, SkinPartType>)Pair.of((Object)((Object)model), (Object)partType), key -> this.renderers.get(key.getValue()));
    }
}

