/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.armourer;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.ArmourerBaseSetting;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerClearDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerCopyDialog;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.dialog.ArmourerReplaceDialog;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.network.UpdateArmourerPacket;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockSetting
extends ArmourerBaseSetting {
    protected final ArmourerBlockEntity blockEntity;

    protected ArmourerBlockSetting(ArmourerMenu container) {
        super("armourer.blockUtils");
        this.blockEntity = (ArmourerBlockEntity)container.getBlockEntity();
    }

    @Override
    public void init() {
        super.init();
        UIButton clearBtn = new UIButton(new CGRect(10.0f, 20.0f, 70.0f, 20.0f));
        clearBtn.setTitle(this.getDisplayText("clear", new Object[0]), 7);
        clearBtn.setTitleColor(UIColor.WHITE, 7);
        clearBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        clearBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::clearAction);
        this.addSubview(clearBtn);
        UIButton copyBtn = new UIButton(new CGRect(10.0f, 45.0f, 70.0f, 20.0f));
        copyBtn.setTitle(this.getDisplayText("copy", new Object[0]), 7);
        copyBtn.setTitleColor(UIColor.WHITE, 7);
        copyBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        copyBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::copyAction);
        this.addSubview(copyBtn);
        UIButton replaceBtn = new UIButton(new CGRect(10.0f, 70.0f, 70.0f, 20.0f));
        replaceBtn.setTitle(this.getDisplayText("replace", new Object[0]), 7);
        replaceBtn.setTitleColor(UIColor.WHITE, 7);
        replaceBtn.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        replaceBtn.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ArmourerBlockSetting::replaceAction);
        this.addSubview(replaceBtn);
    }

    private void clearAction(UIControl sender) {
        ArmourerClearDialog dialog = new ArmourerClearDialog(this.getPartTypes(true));
        dialog.setTitle(NSString.localizedString("armourer.dialog.clear.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("Cubes", dialog.isClearBlocks());
            nbt.putBoolean("Paints", dialog.isClearPaints());
            nbt.putBoolean("Markers", dialog.isClearMarkers());
            nbt.putString("PartType", dialog.selectedPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_CLEAR.buildPacket(this.blockEntity, nbt));
        });
    }

    private void copyAction(UIControl sender) {
        ArmourerCopyDialog dialog = new ArmourerCopyDialog(this.getPartTypes(false));
        dialog.setTitle(NSString.localizedString("armourer.dialog.copy.title", new Object[0]));
        dialog.showInView(this, () -> {
            if (dialog.isCancelled()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("Mirror", dialog.isMirror());
            nbt.putBoolean("Paints", dialog.isCopyPaintData());
            nbt.putString("Source", dialog.sourcePartType().registryName().toString());
            nbt.putString("Destination", dialog.destinationPartType().registryName().toString());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_COPY.buildPacket(this.blockEntity, nbt));
        });
    }

    private void replaceAction(UIControl sender) {
        ArmourerReplaceDialog dialog = new ArmourerReplaceDialog();
        dialog.setTitle(NSString.localizedString("armourer.dialog.replace.title", new Object[0]));
        dialog.showInView(this, () -> {
            ClientLevel level = EnvironmentManager.getClient().level;
            if (dialog.isCancelled() || level == null) {
                return;
            }
            CompoundTag source = new CompoundTag();
            ItemStack selector = dialog.selector();
            if (selector.getItem() instanceof IItemPaintable) {
                selector.save((HolderLookup.Provider)level.registryAccess(), (Tag)source);
            }
            CompoundTag destination = new CompoundTag();
            ItemStack applier = dialog.applier();
            if (applier.getItem() instanceof IItemPaintable) {
                applier.save((HolderLookup.Provider)level.registryAccess(), (Tag)destination);
            }
            if (source.isEmpty() && destination.isEmpty()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.put("Source", (Tag)source);
            nbt.put("Destination", (Tag)destination);
            nbt.putBoolean("KeepColor", dialog.isKeepColor());
            nbt.putBoolean("KeepPaintType", dialog.isKeepPaintType());
            NetworkManager.sendToServer(UpdateArmourerPacket.Field.ITEM_REPLACE.buildPacket(this.blockEntity, nbt));
        });
    }

    public ArrayList<SkinPartType> getPartTypes(boolean usesAll) {
        SkinType skinType = this.blockEntity.skinType();
        SkinProperties skinProperties = this.blockEntity.skinProperties();
        ArrayList<SkinPartType> partTypes = new ArrayList<SkinPartType>();
        if (usesAll) {
            partTypes.add(0, SkinPartTypes.UNKNOWN);
        }
        if (skinType != SkinTypes.BLOCK) {
            partTypes.addAll(skinType.parts());
        } else if (skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK).booleanValue()) {
            partTypes.add(SkinPartTypes.BLOCK_MULTI);
        } else {
            partTypes.add(SkinPartTypes.BLOCK);
        }
        return partTypes;
    }
}

