/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import org.jetbrains.annotations.Nullable;

public class AdvancedPartOffset {

    public static class Builder<T> {
        private final HashMap<SkinPartType, Function<T, OpenTransform3f>> poses = new HashMap();

        public Builder<T> put(SkinPartType partType, float tx, float ty, float tz) {
            return this.put(partType, tx, ty, tz, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> put(SkinPartType partType, float tx, float ty, float tz, float xRot, float yRot, float zRot) {
            return this.put(partType, tx, ty, tz, xRot, yRot, zRot, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> put(SkinPartType partType, float tx, float ty, float tz, float xRot, float yRot, float zRot, float ax, float ay, float az) {
            OpenVector3f translate = new OpenVector3f(tx, ty, tz);
            OpenVector3f rotation = new OpenVector3f(xRot, yRot, zRot);
            OpenVector3f afterTranslate = new OpenVector3f(ax, ay, az);
            OpenTransform3f transform = OpenTransform3f.create(translate, rotation, OpenVector3f.ONE, OpenVector3f.ZERO, afterTranslate);
            return this.add(partType, it -> transform);
        }

        @Nullable
        public OpenTransform3f get(T entity, SkinPartType partType) {
            Function<T, OpenTransform3f> provider = this.poses.get(partType);
            if (provider != null) {
                return provider.apply(entity);
            }
            return null;
        }

        private Builder<T> add(SkinPartType partType, Function<T, OpenTransform3f> provider) {
            this.poses.put(partType, provider);
            return this;
        }
    }
}

