/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.core.data.OptionalDirection;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SkinCubeBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockTintColorProvider {
    public static final DirectionProperty MARKER = DirectionProperty.create((String)"marker", (Direction[])Direction.values());
    public static final BooleanProperty HAS_MARKER = BooleanProperty.create((String)"has_marker");

    public SkinCubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false))).setValue((Property)MARKER, (Comparable)Direction.NORTH));
    }

    public static OptionalDirection getMarker(BlockState blockState) {
        if (blockState.getOptionalValue((Property)HAS_MARKER).orElse(false).booleanValue()) {
            return OptionalDirection.of((Direction)blockState.getValue((Property)MARKER));
        }
        return OptionalDirection.NONE;
    }

    public static BlockState setMarker(BlockState blockState, OptionalDirection direction) {
        OpenDirection dir = direction.direction();
        if (dir != null) {
            return (BlockState)((BlockState)blockState.setValue((Property)HAS_MARKER, (Comparable)Boolean.valueOf(true))).setValue((Property)MARKER, (Comparable)AbstractDirection.unwrap(dir));
        }
        return (BlockState)blockState.setValue((Property)HAS_MARKER, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.SKIN_CUBE.get()).create(level, blockPos, blockState);
    }

    public boolean skipRendering(BlockState state, BlockState state1, Direction dir) {
        return state.getBlock() == state1.getBlock();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MARKER});
        builder.add(new Property[]{HAS_MARKER});
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        Direction facing = rotation.rotate((Direction)blockState.getValue((Property)FACING));
        Direction marker = rotation.rotate((Direction)blockState.getValue((Property)MARKER));
        return (BlockState)((BlockState)blockState.setValue((Property)FACING, (Comparable)facing)).setValue((Property)MARKER, (Comparable)marker);
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return this.rotate(blockState, mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    @Override
    public int getTintColor(BlockState blockState, @Nullable BlockGetter reader, @Nullable BlockPos blockPos, int index) {
        IBlockPaintable paintable;
        SkinPaintColor paintColor;
        BlockEntity blockEntity;
        if (reader == null || blockPos == null) {
            return -1;
        }
        OpenDirection direction = OpenDirection.NORTH;
        if (index > 0 && index < 7) {
            direction = OpenDirection.values()[index - 1];
        }
        if ((blockEntity = reader.getBlockEntity(blockPos)) instanceof IBlockPaintable && (paintColor = (paintable = (IBlockPaintable)blockEntity).getColor(direction)) != null) {
            return paintColor.argb() | 0xFF000000;
        }
        return -1;
    }
}

