/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.builder.blockentity.ColorMixerBlockEntity;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ColorMixerBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider,
IBlockTintColorProvider {
    public ColorMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.COLOR_MIXER.get()).create(level, blockPos, blockState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int n = 0;
        Direction[] directionArray = context.getNearestLookingDirections();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            if (direction.getAxis() == Direction.Axis.Y) {
                return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
            }
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite());
        }
        return null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        return ((IMenuType)ModMenuTypes.COLOR_MIXER.get()).openMenu(player, level.getBlockEntity(blockPos));
    }

    @Override
    public int getTintColor(BlockState blockState, BlockGetter reader, BlockPos blockPos, int index) {
        if (reader == null || blockPos == null || index != 1) {
            return -1;
        }
        BlockEntity blockEntity = reader.getBlockEntity(blockPos);
        if (blockEntity instanceof ColorMixerBlockEntity) {
            ColorMixerBlockEntity blockEntity2 = (ColorMixerBlockEntity)blockEntity;
            return blockEntity2.color().argb() | 0xFF000000;
        }
        return -1;
    }
}

