/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BoundingBoxBlock
extends Block
implements AbstractBlockEntityProvider,
IBlockHandler {
    public BoundingBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.BOUNDING_BOX.get()).create(level, blockPos, blockState);
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 11);
    }

    @Override
    public InteractionResult attackBlock(Level level, BlockPos blockPos, BlockState blockState, Direction direction, Player player, InteractionHand hand) {
        BoundingBoxBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(blockPos);
        if (blockEntity2 instanceof BoundingBoxBlockEntity && (blockEntity = (BoundingBoxBlockEntity)blockEntity2).isValid() && blockEntity.hasColors()) {
            blockEntity.clearArmourerTextureColors();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.FAIL;
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        BoundingBoxBlockEntity blockEntity;
        BlockEntity blockEntity2 = blockGetter.getBlockEntity(blockPos);
        if (blockEntity2 instanceof BoundingBoxBlockEntity && (blockEntity = (BoundingBoxBlockEntity)blockEntity2).isValid()) {
            return Shapes.block();
        }
        return Shapes.empty();
    }

    public RenderShape getRenderShape(BlockState state) {
        if (ModDebugger.boundingBox) {
            return RenderShape.MODEL;
        }
        return RenderShape.INVISIBLE;
    }
}

