/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIScrollViewDelegate;
import com.apple.library.uikit.UIView;
import java.util.function.BiFunction;

public class UIScrollView
extends UIView {
    protected CGPoint contentOffset = CGPoint.ZERO;
    protected CGSize contentSize = CGSize.ZERO;
    protected UIEdgeInsets contentInsets = UIEdgeInsets.ZERO;
    protected UIEdgeInsets scrollIndicatorInsets = new UIEdgeInsets(2.0f, 2.0f, 2.0f, 2.0f);
    protected final DelegateImpl<UIScrollViewDelegate> delegate = DelegateImpl.of(new UIScrollViewDelegate(this){});
    private final boolean isInit;
    private final Indicator verticalIndicator = new Indicator((a, b) -> b);
    private final Indicator horizontalIndicator = new Indicator((a, b) -> a);

    public UIScrollView(CGRect frame) {
        super(frame);
        this.setClipBounds(true);
        super.addSubview(this.verticalIndicator);
        super.addSubview(this.horizontalIndicator);
        this.isInit = true;
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        CGRect bounds = this.bounds();
        CGRect rect = bounds.insetBy(this.scrollIndicatorInsets);
        this.verticalIndicator.setProgress(rect, this.contentOffset.y, this.contentSize.height - bounds.height);
        this.horizontalIndicator.setProgress(rect, this.contentOffset.x, this.contentSize.width - bounds.width);
    }

    @Override
    public void mouseWheel(UIEvent event) {
        if (this.isVerticalScrollable()) {
            float delta = event.delta().y() * this.bounds().height() / 5.0f;
            float tx = this.contentOffset.x;
            float ty = this.contentOffset.y - delta;
            this.setContentOffset(new CGPoint(tx, ty));
            return;
        }
        super.mouseWheel(event);
    }

    public void flashScrollIndicators() {
        this.verticalIndicator.flash();
        this.horizontalIndicator.flash();
    }

    public CGPoint contentOffset() {
        return this.contentOffset;
    }

    public void setContentOffset(CGPoint contentOffset) {
        contentOffset = this.clamp(contentOffset);
        CGRect rect = this.bounds();
        this.contentOffset = contentOffset;
        super.setBounds(new CGRect(contentOffset.x, contentOffset.y, rect.width, rect.height));
        this.didScroll();
    }

    public CGSize contentSize() {
        return this.contentSize;
    }

    public void setContentSize(CGSize contentSize) {
        this.contentSize = contentSize;
        this.updateIndicatorIfNeeded();
        this.setNeedsLayout();
        CGPoint newContentOffset = this.clamp(this.contentOffset);
        if (!newContentOffset.equals(this.contentOffset)) {
            this.setContentOffset(newContentOffset);
        }
    }

    public UIEdgeInsets contentInsets() {
        return this.contentInsets;
    }

    public void setContentInsets(UIEdgeInsets contentInsets) {
        this.contentInsets = contentInsets;
        this.setNeedsLayout();
    }

    public UIEdgeInsets scrollIndicatorInsets() {
        return this.scrollIndicatorInsets;
    }

    public void setScrollIndicatorInsets(UIEdgeInsets scrollIndicatorInsets) {
        this.scrollIndicatorInsets = scrollIndicatorInsets;
        this.setNeedsLayout();
    }

    public boolean showsHorizontalScrollIndicator() {
        return this.horizontalIndicator.isEnabled();
    }

    public void setShowsHorizontalScrollIndicator(boolean showsHorizontalScrollIndicator) {
        this.horizontalIndicator.setEnabled(showsHorizontalScrollIndicator);
        this.updateIndicatorIfNeeded();
    }

    public boolean showsVerticalScrollIndicator() {
        return this.verticalIndicator.isEnabled();
    }

    public void setShowsVerticalScrollIndicator(boolean showsVerticalScrollIndicator) {
        this.verticalIndicator.setEnabled(showsVerticalScrollIndicator);
        this.updateIndicatorIfNeeded();
    }

    public UIScrollViewDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UIScrollViewDelegate delegate) {
        this.delegate.set(delegate);
    }

    @Override
    public void setBounds(CGRect bounds) {
        super.setBounds(bounds);
        if (!this.isInit) {
            return;
        }
        this.contentOffset = new CGPoint(bounds.x, bounds.y);
        this.updateIndicatorIfNeeded();
        this.didScroll();
    }

    @Override
    public void addSubview(UIView view) {
        super.insertViewAtIndex(view, Math.max(this.subviews().size() - 2, 0));
    }

    @Override
    public void insertViewAtIndex(UIView view, int index) {
        super.insertViewAtIndex(view, Math.min(index, Math.max(this.subviews().size() - 2, 0)));
    }

    private boolean isVerticalScrollable() {
        return this.bounds().height() < this.contentSize.height;
    }

    private CGPoint clamp(CGPoint point) {
        CGRect rect = this.bounds();
        UIEdgeInsets edg = this.contentInsets;
        float tx = Math.max(Math.min(point.x, this.contentSize.width - rect.width + edg.right), -edg.left);
        float ty = Math.max(Math.min(point.y, this.contentSize.height - rect.height + edg.bottom), -edg.top);
        if (point.x == tx && point.y == ty) {
            return point;
        }
        return new CGPoint(tx, ty);
    }

    protected void didScroll() {
        this.delegate.invoker().scrollViewDidScroll(this);
    }

    private void updateIndicatorIfNeeded() {
        CGRect bounds = this.bounds();
        CGSize size = this.contentSize();
        this.verticalIndicator.setRadio(bounds.height, size.height);
        this.horizontalIndicator.setRadio(bounds.width, size.width);
    }

    protected static class Indicator
    extends UIView {
        protected float size = 3.0f;
        protected float radio = 0.0f;
        protected boolean allowsDisplay = true;
        protected boolean enabled = true;
        private final BiFunction<Float, Float, Float> selector;

        public Indicator(BiFunction<Float, Float, Float> selector) {
            super(CGRect.ZERO);
            this.selector = selector;
            this.setBackgroundColor(UIColor.of(0x7F000000));
            this.setHidden(true);
        }

        private static float eval(float lhs, float rhs) {
            if (lhs == 0.0f || rhs <= 0.0f) {
                return 0.0f;
            }
            return lhs / rhs;
        }

        static float clamp(float value, float minValue, float maxValue) {
            if (value < minValue) {
                return minValue;
            }
            if (value > maxValue) {
                return maxValue;
            }
            return value;
        }

        public void setProgress(CGRect rect, float offset, float maxSize) {
            float m = this.selector.apply(Float.valueOf(rect.width), Float.valueOf(rect.height)).floatValue();
            float v = Indicator.eval(offset, maxSize) * m * (1.0f - this.radio);
            float p = Indicator.clamp(v, 0.0f, m);
            float q = Indicator.clamp(v + m * this.radio, 0.0f, m);
            float x = this.selector.apply(Float.valueOf(rect.minX() + (float)((int)p)), Float.valueOf(rect.maxX() - this.size)).floatValue();
            float y = this.selector.apply(Float.valueOf(rect.maxY() - this.size), Float.valueOf(rect.minY() + (float)((int)p))).floatValue();
            float width = this.selector.apply(Float.valueOf(q - p), Float.valueOf(this.size)).floatValue();
            float height = this.selector.apply(Float.valueOf(this.size), Float.valueOf(q - p)).floatValue();
            this.setFrame(new CGRect(x, y, width, height));
            this.flash();
        }

        public void setRadio(float value, float maxValue) {
            if (value == 0.0f || maxValue == 0.0f || value >= maxValue) {
                this.setHidden(true);
                this.allowsDisplay = false;
                this.radio = 0.0f;
                return;
            }
            this.radio = Indicator.clamp(value / maxValue, 0.35f, 1.0f);
            this.allowsDisplay = this.isEnabled();
            this.flash();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        private void flash() {
            if (!this.enabled) {
                return;
            }
            this.setHidden(false);
        }
    }
}

